/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.web.handler.sockjs.processor;

import com.google.common.base.Strings;
import io.reactivex.Single;
import io.vertx.core.json.JsonObject;
import io.vertx.reactivex.ext.web.handler.sockjs.BridgeEventContext;
import io.vertx.reactivex.ext.web.handler.sockjs.processor.BridgeEventProcessor;
import io.vertx.reactivex.redis.RedisClient;
import org.apache.logging.log4j.Logger;

public class SetSubscriberCountHeaderProcessor
implements BridgeEventProcessor {
    private RedisClient mRedisClient;
    private boolean mEnable;
    private String mKeyPrefix;
    private String mCountHeaderFieldName;
    private Logger mLog;

    public RedisClient getRedisClient() {
        return this.mRedisClient;
    }

    public void setRedisClient(RedisClient pRedisClient) {
        this.mRedisClient = pRedisClient;
    }

    @Override
    public Single<BridgeEventContext> process(Single<BridgeEventContext> pContext) {
        if (!this.isEnable()) {
            return pContext;
        }
        return pContext.flatMap(ctx -> {
            if (ctx.getBridgeEvent().failed()) {
                return Single.just((Object)ctx);
            }
            if (Strings.isNullOrEmpty((String)ctx.getAddress())) {
                this.getLog().error(() -> String.format("[%s] Address can't empty", ctx.getId() != null ? ctx.getId() : ""));
                return Single.just((Object)ctx);
            }
            this.getLog().debug(() -> String.format("[%s] Trying to fetch value of Redis:KEY:[%s]", ctx.getId(), ctx.getAddressKey()));
            return this.getRedisClient().rxGet(ctx.getAddressKey()).map(count -> this.setHeader((String)count, (BridgeEventContext)ctx)).doOnError(err -> this.getLog().error(String.format("[%s] Error getting value for Key[%s] from redis", ctx.getId(), ctx.getAddressKey()), err));
        });
    }

    protected BridgeEventContext setHeader(String count, BridgeEventContext ctx) {
        String headerValue = count;
        if (Strings.isNullOrEmpty((String)count)) {
            this.getLog().debug(() -> String.format("[%s] Redis:KEY:[%s], Key value is null, Setting header value to 0", ctx.getId(), ctx.getAddressKey()));
            headerValue = "0";
        } else {
            this.getLog().debug(() -> String.format("[%s] Found Redis:KEY:[%s],VALUE:[%s]", ctx.getId(), ctx.getAddressKey(), count));
        }
        JsonObject rawMsg = ctx.getBridgeEvent().getRawMessage().copy();
        JsonObject headers = rawMsg.getJsonObject("headers");
        if (headers == null) {
            headers = new JsonObject();
        }
        headers.put(this.getCountHeaderFieldName(), headerValue);
        rawMsg.put("headers", headers);
        ctx.getBridgeEvent().setRawMessage(rawMsg);
        return ctx;
    }

    public boolean isEnable() {
        return this.mEnable;
    }

    public void setEnable(boolean pEnable) {
        this.mEnable = pEnable;
    }

    public String getKeyPrefix() {
        return this.mKeyPrefix;
    }

    public void setKeyPrefix(String pKeyPrefix) {
        this.mKeyPrefix = pKeyPrefix;
    }

    public String getCountHeaderFieldName() {
        return this.mCountHeaderFieldName;
    }

    public void setCountHeaderFieldName(String pCountHeaderFieldName) {
        this.mCountHeaderFieldName = pCountHeaderFieldName;
    }

    public Logger getLog() {
        return this.mLog;
    }

    public void setLog(Logger pLog) {
        this.mLog = pLog;
    }
}

