/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.web.handler.sockjs;

import com.codahale.metrics.Meter;
import in.erail.glue.component.ServiceArray;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.vertx.core.Handler;
import io.vertx.reactivex.ext.web.handler.sockjs.BridgeEvent;
import io.vertx.reactivex.ext.web.handler.sockjs.BridgeEventContext;
import io.vertx.reactivex.ext.web.handler.sockjs.processor.BridgeEventProcessor;
import java.util.UUID;
import org.apache.logging.log4j.Logger;

public class BridgeEventHandler
implements Handler<BridgeEvent> {
    private Logger mLog;
    private ServiceArray mPublishProcessors;
    private ServiceArray mReceiveProcessors;
    private ServiceArray mRegisterProcessors;
    private ServiceArray mSendProcessors;
    private ServiceArray mSocketClosedProcessors;
    private ServiceArray mSocketCreatedProcessors;
    private ServiceArray mSocketIdleProcessors;
    private ServiceArray mSoketPingProcessors;
    private ServiceArray mUnregisterProcessors;
    private Meter mMetricsBridgeEventSend;
    private Meter mMetricsBridgeEventPublish;
    private Meter mMetricsBridgeEventReceive;
    private Meter mMetricsBridgeEventRegister;
    private Meter mMetricsBridgeEventUnregister;

    public void handle(BridgeEvent pEvent) {
        switch (pEvent.type()) {
            case PUBLISH: {
                this.getMetricsBridgeEventPublish().mark();
                this.process(this.getPublishProcessors(), pEvent);
                break;
            }
            case RECEIVE: {
                this.getMetricsBridgeEventReceive().mark();
                this.process(this.getReceiveProcessors(), pEvent);
                break;
            }
            case REGISTER: {
                this.getMetricsBridgeEventRegister().mark();
                this.process(this.getRegisterProcessors(), pEvent);
                break;
            }
            case SEND: {
                this.getMetricsBridgeEventSend().mark();
                this.process(this.getSendProcessors(), pEvent);
                break;
            }
            case SOCKET_CLOSED: {
                this.process(this.getSocketClosedProcessors(), pEvent);
                break;
            }
            case SOCKET_CREATED: {
                this.process(this.getSocketCreatedProcessors(), pEvent);
                break;
            }
            case SOCKET_IDLE: {
                this.process(this.getSocketIdleProcessors(), pEvent);
                break;
            }
            case SOCKET_PING: {
                this.process(this.getSoketPingProcessors(), pEvent);
                break;
            }
            case UNREGISTER: {
                this.getMetricsBridgeEventUnregister().mark();
                this.process(this.getUnregisterProcessors(), pEvent);
            }
        }
    }

    protected void process(ServiceArray pProcessors, BridgeEvent pEvent) {
        if (pProcessors.getServices() == null || pProcessors.getServices().isEmpty()) {
            pEvent.complete(Boolean.valueOf(true));
            return;
        }
        BridgeEventContext ctx = new BridgeEventContext();
        ctx.setBridgeEvent(pEvent);
        if (this.getLog().isDebugEnabled()) {
            ctx.setId(UUID.randomUUID().toString());
        }
        Observable.fromIterable((Iterable)pProcessors.getServices()).reduce((Object)Single.just((Object)ctx), (acc, processor) -> {
            BridgeEventProcessor p = (BridgeEventProcessor)processor;
            return p.process((Single<BridgeEventContext>)acc);
        }).flatMap(context -> context).doFinally(() -> {
            if (ctx.getBridgeEvent().failed()) {
                this.getLog().debug(() -> String.format("[%s] BridgeEvent Failed: [%s]", ctx.getId(), ctx.getBridgeEvent().getRawMessage()));
                return;
            }
            this.getLog().debug(() -> String.format("[%s] BridgeEvent Success [%s]", ctx.getId(), ctx.getBridgeEvent().getRawMessage()));
            ctx.getBridgeEvent().complete(Boolean.valueOf(true));
        }).subscribe();
    }

    public ServiceArray getPublishProcessors() {
        return this.mPublishProcessors;
    }

    public void setPublishProcessors(ServiceArray pPublishProcessors) {
        this.mPublishProcessors = pPublishProcessors;
    }

    public ServiceArray getReceiveProcessors() {
        return this.mReceiveProcessors;
    }

    public void setReceiveProcessors(ServiceArray pReceiveProcessors) {
        this.mReceiveProcessors = pReceiveProcessors;
    }

    public ServiceArray getRegisterProcessors() {
        return this.mRegisterProcessors;
    }

    public void setRegisterProcessors(ServiceArray pRegisterProcessors) {
        this.mRegisterProcessors = pRegisterProcessors;
    }

    public ServiceArray getSendProcessors() {
        return this.mSendProcessors;
    }

    public void setSendProcessors(ServiceArray pSendProcessors) {
        this.mSendProcessors = pSendProcessors;
    }

    public ServiceArray getSocketClosedProcessors() {
        return this.mSocketClosedProcessors;
    }

    public void setSocketClosedProcessors(ServiceArray pSocketClosedProcessors) {
        this.mSocketClosedProcessors = pSocketClosedProcessors;
    }

    public ServiceArray getSocketCreatedProcessors() {
        return this.mSocketCreatedProcessors;
    }

    public void setSocketCreatedProcessors(ServiceArray pSocketCreatedProcessors) {
        this.mSocketCreatedProcessors = pSocketCreatedProcessors;
    }

    public ServiceArray getSocketIdleProcessors() {
        return this.mSocketIdleProcessors;
    }

    public void setSocketIdleProcessors(ServiceArray pSocketIdleProcessors) {
        this.mSocketIdleProcessors = pSocketIdleProcessors;
    }

    public ServiceArray getSoketPingProcessors() {
        return this.mSoketPingProcessors;
    }

    public void setSoketPingProcessors(ServiceArray pSoketPingProcessors) {
        this.mSoketPingProcessors = pSoketPingProcessors;
    }

    public ServiceArray getUnregisterProcessors() {
        return this.mUnregisterProcessors;
    }

    public void setUnregisterProcessors(ServiceArray pUnregisterProcessors) {
        this.mUnregisterProcessors = pUnregisterProcessors;
    }

    public Logger getLog() {
        return this.mLog;
    }

    public void setLog(Logger pLog) {
        this.mLog = pLog;
    }

    public Meter getMetricsBridgeEventSend() {
        return this.mMetricsBridgeEventSend;
    }

    public void setMetricsBridgeEventSend(Meter pMetricsBridgeEventSend) {
        this.mMetricsBridgeEventSend = pMetricsBridgeEventSend;
    }

    public Meter getMetricsBridgeEventPublish() {
        return this.mMetricsBridgeEventPublish;
    }

    public void setMetricsBridgeEventPublish(Meter pMetricsBridgeEventPublish) {
        this.mMetricsBridgeEventPublish = pMetricsBridgeEventPublish;
    }

    public Meter getMetricsBridgeEventReceive() {
        return this.mMetricsBridgeEventReceive;
    }

    public void setMetricsBridgeEventReceive(Meter pMetricsBridgeEventReceive) {
        this.mMetricsBridgeEventReceive = pMetricsBridgeEventReceive;
    }

    public Meter getMetricsBridgeEventRegister() {
        return this.mMetricsBridgeEventRegister;
    }

    public void setMetricsBridgeEventRegister(Meter pMetricsBridgeEventRegister) {
        this.mMetricsBridgeEventRegister = pMetricsBridgeEventRegister;
    }

    public Meter getMetricsBridgeEventUnregister() {
        return this.mMetricsBridgeEventUnregister;
    }

    public void setMetricsBridgeEventUnregister(Meter pMetricsBridgeEventUnregister) {
        this.mMetricsBridgeEventUnregister = pMetricsBridgeEventUnregister;
    }
}

