/*
 * Decompiled with CFR 0.152.
 */
package in.erail.service;

import in.erail.glue.annotation.StartService;
import in.erail.service.RESTService;
import io.reactivex.schedulers.Schedulers;
import io.vertx.reactivex.core.Vertx;
import org.apache.logging.log4j.Logger;

public abstract class RESTServiceImpl
implements RESTService {
    private boolean mBodyAsJson = true;
    private String mOperationId;
    private String mServiceUniqueId;
    private Vertx mVertx;
    private boolean mEnable = false;
    private Logger mLog;

    @StartService
    public void start() {
        if (this.mEnable) {
            this.getVertx().eventBus().consumer(this.getServiceUniqueId()).toFlowable().subscribeOn(Schedulers.io()).doOnSubscribe(s -> this.getLog().info(() -> String.format("%s[%s] service started", this.getServiceUniqueId(), Thread.currentThread().getName()))).doOnTerminate(() -> this.getLog().info(() -> String.format("%s[%s] service stopped", this.getServiceUniqueId(), Thread.currentThread().getName()))).subscribe(this::process, err -> this.getLog().error(() -> String.format("Process exception:[%s],Error:[%s]", this.getServiceUniqueId(), err)));
        }
    }

    @Override
    public String getOperationId() {
        return this.mOperationId;
    }

    @Override
    public String getServiceUniqueId() {
        return this.mServiceUniqueId;
    }

    public void setOperationId(String pOperationId) {
        this.mOperationId = pOperationId;
    }

    public void setServiceUniqueId(String pServiceUniqueId) {
        this.mServiceUniqueId = pServiceUniqueId;
    }

    public Vertx getVertx() {
        return this.mVertx;
    }

    public void setVertx(Vertx pVertx) {
        this.mVertx = pVertx;
    }

    public boolean isEnable() {
        return this.mEnable;
    }

    public void setEnable(boolean pEnable) {
        this.mEnable = pEnable;
    }

    public Logger getLog() {
        return this.mLog;
    }

    public void setLog(Logger pLog) {
        this.mLog = pLog;
    }

    @Override
    public boolean isBodyAsJson() {
        return this.mBodyAsJson;
    }

    public void setBodyAsJson(boolean pBodyAsJson) {
        this.mBodyAsJson = pBodyAsJson;
    }
}

