/*
 * Decompiled with CFR 0.152.
 */
package in.ejava.rest.plugin.core.client;

import in.ejava.rest.plugin.core.client.Response;
import in.ejava.rest.plugin.core.session.SessionCookieHolder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;

public class RestClientFactory {
    private RestClient restClient;
    private static RestClientFactory instance = new RestClientFactory();

    private RestClientFactory() {
    }

    public static RestClientFactory getInstance() {
        return instance;
    }

    public RestClient getRestClient() {
        return this.restClient;
    }

    public void setRestClient(RestClient restClient) {
        this.restClient = restClient;
    }

    static {
        RestClientFactory.instance.restClient = new RestClient();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RestClient {
        private RestClient() {
        }

        public Response put(String url, byte[] data, Map<String, String> headers, String sessionIdentifier) throws Exception {
            return this.put(url, data, headers, sessionIdentifier, true);
        }

        public Response put(String url, byte[] data, Map<String, String> headers, String sessionIdentifier, boolean followRedirects) throws Exception {
            return this.execute("PUT", url, null, data, headers, sessionIdentifier, followRedirects);
        }

        public Response post(String url, byte[] data, Map<String, String> headers, String sessionIdentifier) throws Exception {
            return this.post(url, data, headers, sessionIdentifier, true);
        }

        public Response post(String url, byte[] data, Map<String, String> headers, String sessionIdentifier, boolean followRedirects) throws Exception {
            return this.execute("POST", url, null, data, headers, sessionIdentifier, followRedirects);
        }

        public Response delete(String url, Map<String, String> headers, String sessionIdentifier) throws Exception {
            return this.delete(url, headers, sessionIdentifier, true);
        }

        public Response delete(String url, Map<String, String> headers, String sessionIdentifier, boolean followRedirects) throws Exception {
            return this.execute("DELETE", url, null, null, headers, sessionIdentifier, followRedirects);
        }

        public Response get(String url, String queryString, Map<String, String> headers, String sessionIdentifier) throws Exception {
            return this.get(url, queryString, headers, sessionIdentifier, true);
        }

        public Response get(String url, String queryString, Map<String, String> headers, String sessionIdentifier, boolean followRedirects) throws Exception {
            return this.execute("GET", url, queryString, null, headers, sessionIdentifier, followRedirects);
        }

        @Deprecated
        private Response execute(String type, String urlStr, String queryString, byte[] data, Map<String, String> headers, String sessionIdentifier) throws Exception {
            return this.execute(type, urlStr, queryString, data, headers, sessionIdentifier, true);
        }

        private Response execute(String type, String urlStr, String queryString, byte[] data, Map<String, String> headers, String sessionIdentifier, boolean followRedirects) throws Exception {
            if (queryString != null && !queryString.isEmpty()) {
                urlStr = urlStr + "?" + queryString;
            }
            URL url = new URL(urlStr);
            HttpURLConnection con = null;
            if ("https".equalsIgnoreCase(url.getProtocol())) {
                HttpsURLConnection sslCon = (HttpsURLConnection)url.openConnection();
                sslCon.setSSLSocketFactory(this.getSSLSocketFactory());
                con = sslCon;
            } else {
                con = (HttpURLConnection)url.openConnection();
            }
            con.setRequestMethod(type);
            con.setInstanceFollowRedirects(followRedirects);
            String cookieString = SessionCookieHolder.getCookieString(sessionIdentifier);
            this.prepareHttpRequest(con, headers, data, cookieString);
            con.connect();
            Response response = this.retrieveResponse(con);
            SessionCookieHolder.updateSessionCookies(sessionIdentifier, response.getResponseHeaders());
            return response;
        }

        private void prepareHttpRequest(HttpURLConnection con, Map<String, String> headers, byte[] bytes, String cookieString) throws IOException {
            String contentType = null;
            if (cookieString != null && !cookieString.isEmpty()) {
                con.setRequestProperty("Cookie", cookieString);
            }
            if (headers != null) {
                contentType = headers.remove("Content-Type");
                for (String key : headers.keySet()) {
                    con.setRequestProperty(key, headers.get(key));
                }
            }
            if (bytes != null && bytes.length > 0) {
                con.setDoOutput(true);
                if (contentType != null) {
                    con.setRequestProperty("Content-Type", contentType);
                }
                OutputStream out = con.getOutputStream();
                out.write(bytes);
                out.flush();
                out.close();
            }
        }

        private Response retrieveResponse(HttpURLConnection con) throws Exception {
            int read;
            InputStream inputStream;
            Response response = new Response();
            response.setStatusCode(con.getResponseCode());
            response.setResponseHeaders(con.getHeaderFields());
            try {
                inputStream = con.getInputStream();
            }
            catch (Exception e) {
                inputStream = con.getErrorStream();
                response.setFailure(e);
            }
            ByteArrayOutputStream container = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((read = inputStream.read(buf, 0, 1024)) > 0) {
                container.write(buf, 0, read);
            }
            response.setResponseData(container.toByteArray());
            return response;
        }

        private SSLSocketFactory getSSLSocketFactory() throws Exception {
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(this.getKeyStore(), this.getTrustStrategy()).build();
            return sslContext.getSocketFactory();
        }

        private KeyStore getKeyStore() {
            return null;
        }

        private TrustStrategy getTrustStrategy() {
            return new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                    return true;
                }
            };
        }
    }
}

