/*
 * Decompiled with CFR 0.152.
 */
package in.ashwanthkumar.slack.webhook.service;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.util.Maps;
import com.google.gson.Gson;
import in.ashwanthkumar.slack.webhook.SlackAttachment;
import in.ashwanthkumar.slack.webhook.SlackMessage;
import in.ashwanthkumar.utils.lang.StringUtils;
import java.io.IOException;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SlackService {
    private final HttpRequestFactory requestFactory;

    public SlackService(Proxy proxy) {
        NetHttpTransport.Builder builder = new NetHttpTransport.Builder();
        builder.setProxy(proxy);
        this.requestFactory = builder.build().createRequestFactory();
    }

    public SlackService() {
        this(null);
    }

    public void push(String webHookUrl, SlackMessage text, String username, String imageOrIcon, String destination, String parse, List<SlackAttachment> attachments) throws IOException {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((String)username)) {
            payload.put("username", username);
        }
        if (StringUtils.startsWith((String)imageOrIcon, (String)"http")) {
            payload.put("icon_url", imageOrIcon);
        } else if (StringUtils.isNotEmpty((String)imageOrIcon)) {
            payload.put("icon_emoji", imageOrIcon);
        }
        if (StringUtils.isNotEmpty((String)destination)) {
            payload.put("channel", destination);
        }
        if (!attachments.isEmpty()) {
            payload.put("attachments", attachments);
        }
        if (StringUtils.isNotEmpty((String)parse)) {
            payload.put("parse", parse);
        }
        payload.put("text", text.toString());
        this.execute(webHookUrl, payload);
    }

    public void push(String webHookUrl, SlackMessage text, String username, String imageOrIcon, String parse, String destination) throws IOException {
        this.push(webHookUrl, text, username, imageOrIcon, destination, parse, new ArrayList<SlackAttachment>());
    }

    public void execute(String webHookUrl, Map<String, Object> payload) throws IOException {
        String jsonEncodedMessage = new Gson().toJson(payload);
        HashMap payloadToSend = Maps.newHashMap();
        payloadToSend.put("payload", jsonEncodedMessage);
        this.requestFactory.buildPostRequest(new GenericUrl(webHookUrl), (HttpContent)new UrlEncodedContent((Object)payloadToSend)).execute();
    }
}

