/*
 * Decompiled with CFR 0.152.
 */
package in.ashwanthkumar.slack.webhook;

import in.ashwanthkumar.slack.webhook.SlackMessage;
import in.ashwanthkumar.slack.webhook.service.SlackService;
import in.ashwanthkumar.slack.webhook.util.StringUtils;
import java.io.IOException;

public class Slack {
    private String webhookUrl;
    private String channel;
    private String user;
    private String icon;
    private SlackService slackService = new SlackService();

    public Slack(String webhookUrl) {
        if (StringUtils.isEmpty(webhookUrl)) {
            throw new IllegalArgumentException("Webhook url is not provided");
        }
        if (!webhookUrl.startsWith("https://hooks.slack.com/services/")) {
            throw new IllegalArgumentException("Slack Webhook url starts with https://hooks.slack.com/services/");
        }
        this.webhookUrl = webhookUrl;
    }

    Slack(String webhookUrl, SlackService mockService) {
        this.webhookUrl = webhookUrl;
        this.slackService = mockService;
    }

    public Slack sendToChannel(String channel) {
        this.channel = "#" + channel;
        return this;
    }

    public Slack sendToUser(String sendToUser) {
        this.channel = "@" + sendToUser;
        return this;
    }

    public Slack displayName(String user) {
        this.user = user;
        return this;
    }

    public Slack icon(String imageOrIcon) {
        this.icon = imageOrIcon;
        return this;
    }

    public void push(SlackMessage message) throws IOException {
        if (message != null) {
            this.slackService.push(this.webhookUrl, message, this.user, this.icon, this.channel);
        }
    }
}

