/*
 * Decompiled with CFR 0.152.
 */
package in.ashwanthkumar.utils.parser;

import in.ashwanthkumar.utils.collections.Lists;
import in.ashwanthkumar.utils.func.Function;
import in.ashwanthkumar.utils.lang.StringUtils;
import in.ashwanthkumar.utils.parser.Failure;
import in.ashwanthkumar.utils.parser.Parser;
import in.ashwanthkumar.utils.parser.ParserResult;
import in.ashwanthkumar.utils.parser.Success;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Parsers {
    public static Parser<String> Literal(final String literal) {
        return new Parser<String>(){

            @Override
            public ParserResult<String> parse(String input) {
                if (StringUtils.startsWith(input, literal)) {
                    String substring = input.substring(StringUtils.size(literal));
                    return Success.of(literal, substring);
                }
                int size = Math.min(StringUtils.size(literal), StringUtils.size(input));
                return Failure.of(String.format("expected '%s' but found '%s'", literal, input.substring(0, size)), input);
            }
        };
    }

    public static Parser<String> Character(char input) {
        return Parsers.Literal(String.valueOf(input));
    }

    public static Parser<Integer> Integer(Integer num) {
        return Parsers.Literal(String.valueOf(num)).map(new Function<String, Integer>(){

            @Override
            public Integer apply(String input) {
                return Integer.valueOf(input);
            }
        });
    }

    public static Parser<Double> Double(Double num) {
        return Parsers.Literal(String.valueOf(num)).map(new Function<String, Double>(){

            @Override
            public Double apply(String input) {
                return Double.valueOf(input);
            }
        });
    }

    public static Parser<String> Regex(final Pattern regex) {
        return new Parser<String>(){

            @Override
            public ParserResult<String> parse(String input) {
                Matcher matcher = regex.matcher(input);
                if (matcher.find()) {
                    return Success.of(matcher.group(), input.substring(matcher.end()));
                }
                return Failure.of(regex.pattern() + " did not match on the " + input, input);
            }
        };
    }

    public static <T> Parser<List<T>> Sequence(final Parser<T> parser) {
        return new Parser<List<T>>(){

            @Override
            public ParserResult<List<T>> parse(String input) {
                List results = Lists.Nil();
                ParserResult result = parser.parse(input);
                while (result.successful()) {
                    results.add(result.get());
                    result = parser.parse(result.getRemainingInput());
                }
                return Success.of(results, result.getRemainingInput());
            }
        };
    }
}

