/*
 * Decompiled with CFR 0.152.
 */
package in.ashwanthkumar.utils.collections;

import in.ashwanthkumar.utils.func.Predicate;
import in.ashwanthkumar.utils.lang.option.Option;
import in.ashwanthkumar.utils.lang.tuple.Tuple2;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Iterables {
    public static <T> boolean exists(Iterable<T> input, Predicate<T> condition) {
        for (T data : input) {
            if (!((Boolean)condition.apply(data)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean forall(Iterable<T> input, Predicate<T> condition) {
        for (T data : input) {
            if (((Boolean)condition.apply(data)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static <T> T head(Iterable<T> iterable) {
        return iterable.iterator().next();
    }

    public static <T> Option<T> headOption(Iterable<T> list) {
        Iterator<T> iterator = list.iterator();
        if (iterator.hasNext()) {
            return Option.option(iterator.next());
        }
        return Option.option(null);
    }

    public static <T> boolean isEmpty(Iterable<T> list) {
        return list == null || !list.iterator().hasNext();
    }

    public static <T> boolean nonEmpty(Iterable<T> list) {
        return !Iterables.isEmpty(list);
    }

    public static <K, V> Map<K, V> toMap(Iterable<Tuple2<K, V>> tuples) {
        HashMap<K, V> map = new HashMap<K, V>();
        for (Tuple2<K, V> tuple : tuples) {
            map.put(tuple._1(), tuple._2());
        }
        return map;
    }
}

