/*
 * Decompiled with CFR 0.152.
 */
package in.ashwanthkumar.gocd.client.types;

import com.google.gson.annotations.SerializedName;
import in.ashwanthkumar.gocd.client.GoCD;
import in.ashwanthkumar.gocd.client.types.Material;
import in.ashwanthkumar.gocd.client.types.Modification;
import in.ashwanthkumar.gocd.client.types.Pipeline;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterialRevision {
    private static final Pattern PIPELINE_REVISION_PATTERN = Pattern.compile("^([^/]+)/(\\d+)/.*");
    private static final Pattern GITHUB_MATERIAL_PATTERN = Pattern.compile("^URL: git@github\\.com:(.+)\\.git,.*");
    private Logger LOG = LoggerFactory.getLogger(MaterialRevision.class);
    @SerializedName(value="changed")
    private boolean changed;
    @SerializedName(value="material")
    private Material material;
    @SerializedName(value="modifications")
    private List<Modification> modifications;

    public MaterialRevision(boolean changed, Material material, List<Modification> modifications) {
        this.changed = changed;
        this.material = material;
        this.modifications = modifications;
    }

    public MaterialRevision() {
    }

    public boolean isChanged() {
        return this.changed;
    }

    public Material getMaterial() {
        return this.material;
    }

    public List<Modification> getModifications() {
        return this.modifications;
    }

    public boolean isPipeline() {
        return this.material.isPipeline();
    }

    public String modificationUrl(Modification modification) {
        if (!this.material.getType().equals("Git") || this.material.getDescription() == null || modification.getRevision() == null) {
            this.LOG.info(String.format("Can't build URL for modification (%s)/(%s)/(%s)", this.material.getType(), this.material.getDescription(), modification.getRevision()));
            return null;
        }
        Matcher matcher = GITHUB_MATERIAL_PATTERN.matcher(this.material.getDescription());
        if (!matcher.matches()) {
            this.LOG.info("Can't build URL for non-GitHub repo: " + this.material.getDescription());
            return null;
        }
        String org_and_repo = matcher.group(1);
        String commit = modification.getRevision();
        if (commit.length() > 6) {
            commit = commit.substring(0, 6);
        }
        return "https://github.com/" + org_and_repo + "/commit/" + commit;
    }

    void addChangesRecursively(GoCD client, List<MaterialRevision> outChanges) throws IOException {
        if (!this.changed) {
            return;
        }
        if (!this.isPipeline()) {
            if (!outChanges.contains(this)) {
                outChanges.add(this);
            }
        } else {
            for (Modification m : this.modifications) {
                Matcher matcher = PIPELINE_REVISION_PATTERN.matcher(m.getRevision());
                if (matcher.matches()) {
                    String pipelineName = matcher.group(1);
                    int pipelineCounter = Integer.parseInt(matcher.group(2));
                    Pipeline pipeline = client.pipelineInstance(pipelineName, pipelineCounter);
                    pipeline.addChangesRecursively(client, outChanges);
                    continue;
                }
                this.LOG.error("Error matching pipeline revision: " + m.getRevision());
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaterialRevision that = (MaterialRevision)o;
        if (this.changed != that.changed) {
            return false;
        }
        if (this.LOG != null ? !this.LOG.equals(that.LOG) : that.LOG != null) {
            return false;
        }
        if (this.material != null ? !this.material.equals(that.material) : that.material != null) {
            return false;
        }
        return !(this.modifications == null ? that.modifications != null : !this.modifications.equals(that.modifications));
    }

    public int hashCode() {
        int result = this.LOG != null ? this.LOG.hashCode() : 0;
        result = 31 * result + (this.changed ? 1 : 0);
        result = 31 * result + (this.material != null ? this.material.hashCode() : 0);
        result = 31 * result + (this.modifications != null ? this.modifications.hashCode() : 0);
        return result;
    }
}

