/*
 * Decompiled with CFR 0.152.
 */
package in.ashwanthkumar.gocd.client.types;

import com.google.gson.annotations.SerializedName;
import in.ashwanthkumar.gocd.client.types.Pagination;
import in.ashwanthkumar.gocd.client.types.Pipeline;
import in.ashwanthkumar.gocd.client.types.Stage;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class History {
    private Logger LOG = LoggerFactory.getLogger(History.class);
    @SerializedName(value="pipelines")
    private List<Pipeline> pipelines;
    @SerializedName(value="pagination")
    private Pagination pagination;

    public History(List<Pipeline> pipelines, Pagination pagination) {
        this.pipelines = pipelines;
        this.pagination = pagination;
    }

    public History() {
    }

    public List<Pipeline> getPipelines() {
        return this.pipelines;
    }

    public Pagination getPagination() {
        return this.pagination;
    }

    public Stage previousRun(int pipelineCounter, String stageName, int stageCounter) {
        this.LOG.debug(String.format("Looking for stage before %d/%s/%d", pipelineCounter, stageName, stageCounter));
        for (Pipeline pipeline : this.pipelines) {
            for (Stage stage : pipeline.getStages()) {
                this.LOG.debug(String.format("Checking %d/%s/%d", pipeline.getCounter(), stage.getName(), stage.getCounter()));
                if (!stage.getName().equals(stageName)) continue;
                if (pipeline.getCounter() == pipelineCounter && stage.getCounter() < stageCounter) {
                    return stage;
                }
                if (pipeline.getCounter() >= pipelineCounter) continue;
                return stage;
            }
        }
        return null;
    }

    public String toString() {
        if (this.pipelines != null && this.pipelines.size() > 0) {
            if (this.pipelines.size() > 1) {
                return this.pipelines.get(0).toString() + "...";
            }
            return this.pipelines.get(0).toString();
        }
        return "No history";
    }
}

