/*
 * Decompiled with CFR 0.152.
 */
package in.ashwanthkumar.gocd.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import in.ashwanthkumar.gocd.client.http.HttpClient;
import in.ashwanthkumar.gocd.client.types.History;
import in.ashwanthkumar.gocd.client.types.Pipeline;
import in.ashwanthkumar.gocd.client.types.PipelineDependency;
import in.ashwanthkumar.gocd.client.types.PipelineRunStatus;
import in.ashwanthkumar.gocd.client.types.PipelineStatus;
import in.ashwanthkumar.gocd.client.types.Stage;
import in.ashwanthkumar.utils.collections.Lists;
import in.ashwanthkumar.utils.func.Function;
import in.ashwanthkumar.utils.func.Predicate;
import in.ashwanthkumar.utils.lang.StringUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoCD {
    private static Logger LOG = LoggerFactory.getLogger(GoCD.class);
    private String server;
    private HttpClient client;

    public GoCD(String server, String username, String password) {
        this.server = server;
        this.client = new HttpClient(username, password);
    }

    GoCD(String server, String username, String password, String mockResponse) {
        this(server, username, password);
        this.client.setMockResponse(mockResponse);
    }

    public List<String> allPipelineNames(final String pipelinePrefix) throws IOException {
        String xml = this.client.getXML(this.buildUrl("/go/api/pipelines.xml"));
        Document doc = Jsoup.parse((String)xml);
        Elements pipelineElements = doc.select("pipeline[href]");
        List pipelines = Lists.filter((Iterable)Lists.map((Iterable)pipelineElements, (Function)new Function<Element, String>(){

            public String apply(Element element) {
                String href = element.attr("href");
                String apiPrefix = "/go/api/pipelines/";
                return href.substring(href.indexOf(apiPrefix) + apiPrefix.length(), href.indexOf("/stages.xml"));
            }
        }), (Predicate)new Predicate<String>(){

            public Boolean apply(String s) {
                return StringUtils.isEmpty((String)pipelinePrefix) || s.startsWith(pipelinePrefix);
            }
        });
        return pipelines;
    }

    public List<PipelineDependency> upstreamDependencies(String pipeline, int version) throws IOException {
        JsonObject result = this.client.getRawJson(this.buildUrl("/go/pipelines/value_stream_map/" + pipeline + "/" + version + ".json")).getAsJsonObject();
        List dependencies = Lists.of((Object[])new PipelineDependency[]{new PipelineDependency(pipeline, version)});
        if (!result.has("levels")) {
            return dependencies;
        }
        JsonArray levels = result.getAsJsonArray("levels");
        for (JsonElement level : levels) {
            JsonArray nodes = level.getAsJsonObject().getAsJsonArray("nodes");
            for (JsonElement node : nodes) {
                JsonObject nodeObj = node.getAsJsonObject();
                String name = nodeObj.get("name").getAsString();
                if (name.equals(pipeline)) {
                    return dependencies;
                }
                if (!nodeObj.get("node_type").getAsString().equalsIgnoreCase("PIPELINE")) continue;
                JsonArray instances = nodeObj.getAsJsonArray("instances");
                for (JsonElement instance : instances) {
                    int counter = instance.getAsJsonObject().get("counter").getAsInt();
                    dependencies.add(new PipelineDependency().setPipelineName(name).setVersion(counter));
                }
            }
        }
        return dependencies;
    }

    public PipelineStatus pipelineStatus(String pipeline) throws IOException {
        return this.client.getAs(this.buildUrl("/go/api/pipelines/" + pipeline + "/status"), PipelineStatus.class);
    }

    public Pipeline pipelineInstance(String pipeline, int pipelineCounter) throws IOException {
        return this.client.getAs(this.buildUrl("/go/api/pipelines/" + pipeline + "/instace/" + pipelineCounter), Pipeline.class);
    }

    public History pipelineHistory(String pipeline) throws IOException {
        return this.pipelineHistory(pipeline, 0);
    }

    public History pipelineHistory(String pipeline, int offset) throws IOException {
        return this.client.getAs(this.buildUrl("/go/api/pipelines/" + pipeline + "/history/" + offset), History.class);
    }

    public Map<Integer, PipelineRunStatus> pipelineRunStatus(String pipeline) throws IOException {
        return this.pipelineRunStatus(pipeline, 0);
    }

    public Map<Integer, PipelineRunStatus> pipelineRunStatus(String pipelineName, int offset) throws IOException {
        TreeMap<Integer, PipelineRunStatus> result = new TreeMap<Integer, PipelineRunStatus>(Collections.reverseOrder());
        History history = this.pipelineHistory(pipelineName, offset);
        for (Pipeline pipeline : history.getPipelines()) {
            if (pipeline.isPreparingToSchedule()) continue;
            PipelineRunStatus status = this.pipelineStatusFrom(pipeline.getStages());
            LOG.debug(pipeline + "@" + pipeline.getCounter() + " has " + (Object)((Object)status));
            result.put(pipeline.getCounter(), status);
        }
        return result;
    }

    private PipelineRunStatus pipelineStatusFrom(List<Stage> stages) {
        for (Stage stage : stages) {
            boolean stageFailed = stage.getResult().equalsIgnoreCase("failed");
            if (!stageFailed) continue;
            return PipelineRunStatus.FAILED;
        }
        return PipelineRunStatus.PASSED;
    }

    private String buildUrl(String resource) {
        try {
            return URI.create(String.format("%s/%s", this.server, resource)).normalize().toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

