/*
 * Decompiled with CFR 0.152.
 */
package com.tw.go.plugin.model;

import com.tw.go.plugin.model.ShallowClone;
import com.tw.go.plugin.util.StringUtil;
import java.util.Objects;
import java.util.Optional;

public class GitConfig {
    private String url;
    private String username;
    private String password;
    private String branch;
    private boolean subModule = false;
    private boolean recursiveSubModuleUpdate = true;
    private boolean noCheckout = false;
    private Optional<ShallowClone> shallowClone = Optional.empty();

    public GitConfig(String url) {
        this.url = url;
    }

    public GitConfig(String url, String username, String password, String branch) {
        this(url, username, password, branch, true, false);
    }

    public GitConfig(String url, String username, String password, String branch, boolean recursiveSubModuleUpdate, boolean shallowClone) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.branch = branch;
        this.recursiveSubModuleUpdate = recursiveSubModuleUpdate;
        this.shallowClone = shallowClone ? Optional.of(new ShallowClone()) : Optional.empty();
    }

    public boolean isRemoteUrl() {
        return this.url.startsWith("http://") || this.url.startsWith("https://");
    }

    public boolean hasCredentials() {
        return !StringUtil.isEmpty(this.url) && !StringUtil.isEmpty(this.password);
    }

    public String getEffectiveUrl() {
        if (this.isRemoteUrl() && this.hasCredentials()) {
            return this.getUrlWithCredentials();
        }
        return this.getUrl();
    }

    public String getUrlWithCredentials() {
        String[] parts = this.url.split("://");
        return String.format("%s://%s:%s@%s", parts[0], this.username, this.password, parts[1]);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRemoteBranch() {
        return String.format("origin/%s", this.getEffectiveBranch());
    }

    public String getEffectiveBranch() {
        return StringUtil.isEmpty(this.branch) ? "master" : this.branch;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public boolean isSubModule() {
        return this.subModule;
    }

    public void setSubModule(boolean subModule) {
        this.subModule = subModule;
    }

    public boolean isRecursiveSubModuleUpdate() {
        return this.recursiveSubModuleUpdate;
    }

    public void setRecursiveSubModuleUpdate(boolean recursiveSubModuleUpdate) {
        this.recursiveSubModuleUpdate = recursiveSubModuleUpdate;
    }

    public boolean isShallowClone() {
        return this.shallowClone.isPresent();
    }

    public Optional<ShallowClone> getShallowClone() {
        return this.shallowClone;
    }

    public void setShallowClone(ShallowClone shallowClone) {
        this.shallowClone = Optional.of(shallowClone);
    }

    public boolean isNoCheckout() {
        return this.noCheckout;
    }

    public void setNoCheckout(boolean noCheckout) {
        this.noCheckout = noCheckout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitConfig gitConfig = (GitConfig)o;
        return this.subModule == gitConfig.subModule && this.recursiveSubModuleUpdate == gitConfig.recursiveSubModuleUpdate && this.noCheckout == gitConfig.noCheckout && Objects.equals(this.url, gitConfig.url) && Objects.equals(this.username, gitConfig.username) && Objects.equals(this.password, gitConfig.password) && Objects.equals(this.branch, gitConfig.branch) && this.shallowClone.equals(gitConfig.shallowClone);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.username, this.password, this.branch, this.subModule, this.recursiveSubModuleUpdate, this.noCheckout, this.shallowClone);
    }
}

