/*
 * Decompiled with CFR 0.152.
 */
package com.tw.go.plugin.git;

import com.tw.go.plugin.model.Revision;
import com.tw.go.plugin.util.DateUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GitModificationParser {
    private static final String SPACES = "\\s+";
    private static final String COMMENT_INDENT = "\\s{4}";
    private static final String COMMENT_TEXT = "(.*)";
    private static final String HASH = "(\\w+)";
    private static final String DATE = "(.+)";
    private static final String AUTHOR = "(.+)";
    private static final String MULTIPLE_HASHES = "(.+)";
    private static final Pattern COMMIT_PATTERN = Pattern.compile("^commit\\s+(\\w+)$");
    private static final Pattern MERGE_PATTERN = Pattern.compile("^Merge:\\s+(.+)$");
    private static final Pattern AUTHOR_PATTERN = Pattern.compile("^Author:\\s+(.+)$");
    private static final Pattern DATE_PATTERN = Pattern.compile("^Date:\\s+(.+)$");
    private static final Pattern COMMENT_PATTERN = Pattern.compile("^\\s{4}(.*)$");
    private final LinkedList<Revision> revisions = new LinkedList();

    public List<Revision> parse(List<String> output) {
        for (String line : output) {
            this.processLine(line);
        }
        return this.revisions;
    }

    public void processLine(String line) {
        Matcher commentMatcher;
        Matcher dateMatcher;
        Matcher authorMatcher;
        Matcher mergeMatcher;
        Matcher matcher = COMMIT_PATTERN.matcher(line);
        if (matcher.matches()) {
            this.revisions.add(new Revision(matcher.group(1), null, "", "", null, null));
        }
        if ((mergeMatcher = MERGE_PATTERN.matcher(line)).matches()) {
            this.revisions.getLast().setMergeCommit(true);
        }
        if ((authorMatcher = AUTHOR_PATTERN.matcher(line)).matches()) {
            this.revisions.getLast().setUser(authorMatcher.group(1));
        }
        if ((dateMatcher = DATE_PATTERN.matcher(line)).matches()) {
            this.revisions.getLast().setTimestamp(DateUtils.parseISO8601(dateMatcher.group(1)));
        }
        if ((commentMatcher = COMMENT_PATTERN.matcher(line)).matches()) {
            Revision last = this.revisions.getLast();
            Object comment = last.getComment();
            if (!((String)comment).isEmpty()) {
                comment = (String)comment + "\n";
            }
            last.setComment((String)comment + commentMatcher.group(1));
        }
    }
}

