/*
 * Decompiled with CFR 0.152.
 */
package com.tw.go.plugin;

import com.tw.go.plugin.GitHelper;
import com.tw.go.plugin.cmd.ProcessOutputStreamConsumer;
import com.tw.go.plugin.git.GitCmdHelper;
import com.tw.go.plugin.jgit.JGitHelper;
import com.tw.go.plugin.model.GitConfig;
import java.io.File;

public class HelperFactory {
    public static GitHelper git(GitConfig gitConfig, File workingDirectory, ProcessOutputStreamConsumer stdOut, ProcessOutputStreamConsumer stdErr) {
        GitHelper gitCmd = HelperFactory.gitCmd(gitConfig, workingDirectory, stdOut, stdErr);
        if (HelperFactory.isAvailable(gitCmd)) {
            return gitCmd;
        }
        return HelperFactory.jGit(gitConfig, workingDirectory, stdOut, stdErr);
    }

    public static GitHelper gitCmd(GitConfig gitConfig, File workingDirectory, ProcessOutputStreamConsumer stdOut, ProcessOutputStreamConsumer stdErr) {
        return new GitCmdHelper(gitConfig, workingDirectory, stdOut, stdErr);
    }

    public static GitHelper jGit(GitConfig gitConfig, File workingDirectory, ProcessOutputStreamConsumer stdOut, ProcessOutputStreamConsumer stdErr) {
        return new JGitHelper(gitConfig, workingDirectory, stdOut, stdErr);
    }

    public static GitHelper git(GitConfig gitConfig, File workingDirectory) {
        GitHelper gitCmd = HelperFactory.gitCmd(gitConfig, workingDirectory);
        if (HelperFactory.isAvailable(gitCmd)) {
            return gitCmd;
        }
        return HelperFactory.jGit(gitConfig, workingDirectory);
    }

    public static GitHelper gitCmd(GitConfig gitConfig, File workingDirectory) {
        return new GitCmdHelper(gitConfig, workingDirectory);
    }

    public static GitHelper jGit(GitConfig gitConfig, File workingDirectory) {
        return new JGitHelper(gitConfig, workingDirectory);
    }

    private static boolean isAvailable(GitHelper gitCmd) {
        try {
            gitCmd.version();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

