/*
 * Decompiled with CFR 0.152.
 */
package com.tw.go.plugin.model;

import com.tw.go.plugin.util.StringUtil;

public class GitConfig {
    private String url;
    private String username;
    private String password;
    private String branch;
    private boolean subModule = false;
    private boolean recursiveSubModuleUpdate = true;
    private boolean shallowClone = false;

    public GitConfig(String url) {
        this.url = url;
    }

    public GitConfig(String url, String username, String password, String branch) {
        this(url, username, password, branch, true, false);
    }

    public GitConfig(String url, String username, String password, String branch, boolean recursiveSubModuleUpdate, boolean shallowClone) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.branch = branch;
        this.recursiveSubModuleUpdate = recursiveSubModuleUpdate;
        this.shallowClone = shallowClone;
    }

    public boolean isRemoteUrl() {
        return this.url.startsWith("http://") || this.url.startsWith("https://");
    }

    public boolean hasCredentials() {
        return !StringUtil.isEmpty(this.url) && !StringUtil.isEmpty(this.password);
    }

    public String getEffectiveUrl() {
        if (this.isRemoteUrl() && this.hasCredentials()) {
            return this.getUrlWithCredentials();
        }
        return this.getUrl();
    }

    public String getUrlWithCredentials() {
        String[] parts = this.url.split("://");
        return String.format("%s://%s:%s@%s", parts[0], this.username, this.password, parts[1]);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRemoteBranch() {
        return String.format("origin/%s", this.getEffectiveBranch());
    }

    public String getEffectiveBranch() {
        return StringUtil.isEmpty(this.branch) ? "master" : this.branch;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public boolean isSubModule() {
        return this.subModule;
    }

    public void setSubModule(boolean subModule) {
        this.subModule = subModule;
    }

    public boolean isRecursiveSubModuleUpdate() {
        return this.recursiveSubModuleUpdate;
    }

    public void setRecursiveSubModuleUpdate(boolean recursiveSubModuleUpdate) {
        this.recursiveSubModuleUpdate = recursiveSubModuleUpdate;
    }

    public boolean isShallowClone() {
        return this.shallowClone;
    }

    public void setShallowClone(boolean shallowClone) {
        this.shallowClone = shallowClone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitConfig gitConfig = (GitConfig)o;
        if (this.recursiveSubModuleUpdate != gitConfig.recursiveSubModuleUpdate) {
            return false;
        }
        if (this.shallowClone != gitConfig.shallowClone) {
            return false;
        }
        if (this.branch != null ? !this.branch.equals(gitConfig.branch) : gitConfig.branch != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(gitConfig.password) : gitConfig.password != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(gitConfig.url) : gitConfig.url != null) {
            return false;
        }
        return !(this.username != null ? !this.username.equals(gitConfig.username) : gitConfig.username != null);
    }

    public int hashCode() {
        int result = this.url != null ? this.url.hashCode() : 0;
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.branch != null ? this.branch.hashCode() : 0);
        result = 31 * result + (this.recursiveSubModuleUpdate ? 1 : 0);
        result = 31 * result + (this.shallowClone ? 1 : 0);
        return result;
    }
}

