/*
 * Decompiled with CFR 0.152.
 */
package com.tw.go.plugin.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DateUtils {
    private static final DateTimeFormatter formatter = ISODateTimeFormat.dateTimeNoMillis();

    public static Date parseISO8601(String date) {
        try {
            DateTime dateTime = formatter.parseDateTime(date);
            return dateTime.toDate();
        }
        catch (Exception e) {
            try {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss ZZZZZ").parse(date);
            }
            catch (ParseException e2) {
                try {
                    return DateUtils.dateFormatFor("yyyy-MM-dd'T'HH:mm:ss", "UTC").parse(date);
                }
                catch (ParseException e3) {
                    throw new RuntimeException(e3);
                }
            }
        }
    }

    public static String formatRFC822(Date date) {
        return new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss ZZZZZ").format(date);
    }

    private static SimpleDateFormat dateFormatFor(String simpleDateFormat, String timeZone) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(simpleDateFormat);
        dateFormat.setTimeZone(TimeZone.getTimeZone(timeZone));
        return dateFormat;
    }
}

