/*
 * Decompiled with CFR 0.152.
 */
package com.tw.go.plugin.git;

import com.tw.go.plugin.GitHelper;
import com.tw.go.plugin.cmd.Console;
import com.tw.go.plugin.cmd.ConsoleResult;
import com.tw.go.plugin.cmd.InMemoryConsumer;
import com.tw.go.plugin.cmd.ProcessOutputStreamConsumer;
import com.tw.go.plugin.git.GitModificationParser;
import com.tw.go.plugin.model.GitConfig;
import com.tw.go.plugin.model.Revision;
import com.tw.go.plugin.util.DateUtils;
import com.tw.go.plugin.util.ListUtil;
import com.tw.go.plugin.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.io.FileUtils;

public class GitCmdHelper
extends GitHelper {
    private static final Pattern GIT_SUBMODULE_STATUS_PATTERN = Pattern.compile("^.[0-9a-fA-F]{40} (.+?)( \\(.+\\))?$");
    private static final Pattern GIT_SUBMODULE_URL_PATTERN = Pattern.compile("^submodule\\.(.+)\\.url (.+)$");
    private static final Pattern GIT_DIFF_TREE_PATTERN = Pattern.compile("^(.{1,2})\\s+(.+)$");

    public GitCmdHelper(GitConfig gitConfig, File workingDir) {
        this(gitConfig, workingDir, new ProcessOutputStreamConsumer(new InMemoryConsumer()), new ProcessOutputStreamConsumer(new InMemoryConsumer()));
    }

    public GitCmdHelper(GitConfig gitConfig, File workingDir, ProcessOutputStreamConsumer stdOut, ProcessOutputStreamConsumer stdErr) {
        super(gitConfig, workingDir, stdOut, stdErr);
    }

    @Override
    public String version() {
        CommandLine gitLsRemote = Console.createCommand("--version");
        return this.runAndGetOutput(gitLsRemote).stdOut().get(0);
    }

    @Override
    public void checkConnection() {
        CommandLine gitCmd = Console.createCommand("ls-remote", this.gitConfig.getEffectiveUrl());
        this.runAndGetOutput(gitCmd);
    }

    @Override
    public void cloneRepository() {
        ArrayList<String> args = new ArrayList<String>(Arrays.asList("clone", String.format("--branch=%s", this.gitConfig.getEffectiveBranch())));
        if (this.gitConfig.isShallowClone()) {
            args.add("--depth=1");
        }
        args.add(this.gitConfig.getEffectiveUrl());
        args.add(this.workingDir.getAbsolutePath());
        CommandLine gitClone = Console.createCommand(ListUtil.toArray(args));
        this.runAndGetOutput(gitClone, null, this.stdOut, this.stdErr);
    }

    @Override
    public void checkoutRemoteBranchToLocal() {
        CommandLine gitCmd = Console.createCommand("checkout", "-f", this.gitConfig.getEffectiveBranch());
        this.runOrBomb(gitCmd);
    }

    @Override
    public String workingRepositoryUrl() {
        CommandLine gitConfig = Console.createCommand("config", "remote.origin.url");
        return this.runAndGetOutput(gitConfig).stdOut().get(0);
    }

    @Override
    public String getCurrentBranch() {
        CommandLine gitRevParse = Console.createCommand("rev-parse", "--abbrev-ref", "HEAD");
        return this.runAndGetOutput(gitRevParse).stdOut().get(0);
    }

    @Override
    public int getCommitCount() {
        CommandLine gitCmd = Console.createCommand("rev-list", "HEAD", "--count");
        return Integer.parseInt(this.runAndGetOutput(gitCmd).stdOut().get(0));
    }

    @Override
    public String currentRevision() {
        CommandLine gitLog = Console.createCommand("log", "-1", "--pretty=format:%H");
        return this.runAndGetOutput(gitLog).stdOut().get(0);
    }

    @Override
    public List<Revision> getAllRevisions() {
        return this.gitLog("log", "--date=iso", "--pretty=medium");
    }

    @Override
    public Revision getLatestRevision() {
        return this.gitLog("log", "-1", "--date=iso", "--pretty=medium").get(0);
    }

    @Override
    public List<Revision> getRevisionsSince(String revision) {
        return this.gitLog("log", String.format("%s..", revision), "--date=iso", "--pretty=medium");
    }

    @Override
    public Revision getDetailsForRevision(String sha) {
        return this.gitLog("log", "-1", sha, "--date=iso", "--pretty=medium").get(0);
    }

    @Override
    public Map<String, String> getBranchToRevisionMap(String pattern) {
        CommandLine gitCmd = Console.createCommand("show-ref");
        List<String> outputLines = this.runAndGetOutput(gitCmd).stdOut();
        HashMap<String, String> branchToRevisionMap = new HashMap<String, String>();
        for (String line : outputLines) {
            if (!line.contains(pattern)) continue;
            String[] parts = line.split(" ");
            String branch = parts[1].replace(pattern, "");
            String revision = parts[0];
            if (branch.equals("HEAD")) continue;
            branchToRevisionMap.put(branch, revision);
        }
        return branchToRevisionMap;
    }

    private List<Revision> gitLog(String ... args) {
        CommandLine gitLog = Console.createCommand(args);
        List<String> gitLogOutput = this.runAndGetOutput(gitLog).stdOut();
        List<Revision> revisions = new GitModificationParser().parse(gitLogOutput);
        for (Revision revision : revisions) {
            this.addModifiedFiles(revision);
        }
        return revisions;
    }

    private void addModifiedFiles(Revision revision) {
        List<String> diffTreeOutput = this.diffTree(revision.getRevision()).stdOut();
        for (String resultLine : diffTreeOutput) {
            if (resultLine.equals(revision.getRevision())) continue;
            Matcher m = this.matchResultLine(resultLine);
            if (!m.find()) {
                throw new RuntimeException(String.format("Unable to parse git-diff-tree output line: %s\nFrom output:\n %s", resultLine, ListUtil.join(diffTreeOutput, "\n")));
            }
            revision.createModifiedFile(m.group(2), this.parseGitAction(m.group(1).charAt(0)));
        }
    }

    private ConsoleResult diffTree(String node) {
        CommandLine gitCmd = Console.createCommand("diff-tree", "--name-status", "--root", "-r", "-c", node);
        return this.runAndGetOutput(gitCmd);
    }

    private Matcher matchResultLine(String resultLine) {
        return GIT_DIFF_TREE_PATTERN.matcher(resultLine);
    }

    private String parseGitAction(char action) {
        switch (action) {
            case 'A': {
                return "added";
            }
            case 'M': {
                return "modified";
            }
            case 'D': {
                return "deleted";
            }
        }
        return "unknown";
    }

    private String modificationTemplate(String separator) {
        return "%cn <%ce>%n%H%n%ai%n%n%s%n%b%n" + separator;
    }

    @Override
    public void pull() {
        CommandLine gitCommit = Console.createCommand("pull");
        this.runOrBomb(gitCommit);
    }

    @Override
    public void fetch(String refSpec) {
        this.stdOut.consumeLine("[GIT] Fetching changes");
        ArrayList<String> args = new ArrayList<String>(Arrays.asList("fetch", "origin"));
        if (!StringUtil.isEmpty(refSpec)) {
            args.add(refSpec);
        }
        CommandLine gitFetch = Console.createCommand(ListUtil.toArray(args));
        this.runOrBomb(gitFetch);
    }

    @Override
    public void resetHard(String revision) {
        this.stdOut.consumeLine("[GIT] Updating working copy to revision " + revision);
        CommandLine gitResetHard = Console.createCommand("reset", "--hard", revision);
        this.runOrBomb(gitResetHard);
    }

    @Override
    public void cleanAllUnversionedFiles() {
        this.stdOut.consumeLine("[GIT] Cleaning all unversioned files in working copy");
        if (this.isSubmoduleEnabled()) {
            for (Map.Entry<String, String> submoduleFolder : this.submoduleUrls().entrySet()) {
                this.cleanUnversionedFiles(new File(this.workingDir, submoduleFolder.getKey()));
            }
        }
        this.cleanUnversionedFiles(this.workingDir);
    }

    private void cleanUnversionedFiles(File workingDir) {
        CommandLine gitClean = Console.createCommand("clean", "-dff");
        this.runAndGetOutput(gitClean, workingDir, this.stdOut, this.stdErr);
    }

    @Override
    public void gc() {
        this.stdOut.consumeLine("[GIT] Performing git gc");
        CommandLine gitGc = Console.createCommand("gc", "--auto");
        this.runOrBomb(gitGc);
    }

    @Override
    public Map<String, String> submoduleUrls() {
        CommandLine gitConfig = Console.createCommand("config", "--get-regexp", "^submodule\\..+\\.url");
        List<Object> submoduleList = new ArrayList();
        try {
            submoduleList = this.runAndGetOutput(gitConfig).stdOut();
        }
        catch (Exception e) {
            // empty catch block
        }
        HashMap<String, String> submoduleUrls = new HashMap<String, String>();
        for (String string : submoduleList) {
            Matcher m = GIT_SUBMODULE_URL_PATTERN.matcher(string);
            if (!m.find()) {
                throw new RuntimeException(String.format("Unable to parse git-config output line: %s\nFrom output:\n%s", string, ListUtil.join(submoduleList, "\n")));
            }
            submoduleUrls.put(m.group(1), m.group(2));
        }
        return submoduleUrls;
    }

    @Override
    public List<String> submoduleFolders() {
        CommandLine gitCmd = Console.createCommand("submodule", "status");
        return this.submoduleFolders(this.runAndGetOutput(gitCmd).stdOut());
    }

    private List<String> submoduleFolders(List<String> submoduleLines) {
        ArrayList<String> submoduleFolders = new ArrayList<String>();
        for (String submoduleLine : submoduleLines) {
            Matcher m = GIT_SUBMODULE_STATUS_PATTERN.matcher(submoduleLine);
            if (!m.find()) {
                throw new RuntimeException(String.format("Unable to parse git-submodule output line: %s\nFrom output:\n%s", submoduleLine, ListUtil.join(submoduleLines, "\n")));
            }
            submoduleFolders.add(m.group(1));
        }
        return submoduleFolders;
    }

    @Override
    public void printSubmoduleStatus() {
        this.stdOut.consumeLine("[GIT] Git sub-module status");
        CommandLine gitSubModuleStatus = Console.createCommand("submodule", "status");
        this.runOrBomb(gitSubModuleStatus);
    }

    @Override
    public void checkoutAllModifiedFilesInSubmodules() {
        this.stdOut.consumeLine("[GIT] Removing modified files in submodules");
        CommandLine gitSubmoduleCheckout = Console.createCommand("submodule", "foreach", "--recursive", "git", "checkout", ".");
        this.runOrBomb(gitSubmoduleCheckout);
    }

    @Override
    public int getSubModuleCommitCount(String subModuleFolder) {
        CommandLine gitCmd = Console.createCommand("rev-list", "HEAD", "--count");
        return Integer.parseInt(this.runAndGetOutput(gitCmd, new File(this.workingDir, subModuleFolder)).stdOut().get(0));
    }

    @Override
    public void submoduleInit() {
        CommandLine gitSubModuleInit = Console.createCommand("submodule", "init");
        this.runOrBomb(gitSubModuleInit);
    }

    @Override
    public void submoduleSync() {
        CommandLine gitSubModuleSync = Console.createCommand("submodule", "sync");
        this.runOrBomb(gitSubModuleSync);
        CommandLine gitSubModuleForEachSync = Console.createCommand("submodule", "foreach", "--recursive", "git", "submodule", "sync");
        this.runOrBomb(gitSubModuleForEachSync);
    }

    @Override
    public void submoduleUpdate() {
        CommandLine gitSubModuleUpdate = Console.createCommand("submodule", "update");
        this.runOrBomb(gitSubModuleUpdate);
    }

    @Override
    public void init() {
        CommandLine gitCmd = Console.createCommand("init");
        this.runOrBomb(gitCmd);
    }

    @Override
    public void add(File fileToAdd) {
        CommandLine gitAdd = Console.createCommand("add", fileToAdd.getName());
        this.runOrBomb(gitAdd);
    }

    @Override
    public void commit(String message) {
        CommandLine gitCommit = Console.createCommand("commit", "-m", message);
        this.runOrBomb(gitCommit);
    }

    @Override
    public void commitOnDate(String message, Date commitDate) {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("GIT_AUTHOR_DATE", DateUtils.formatRFC822(commitDate));
        CommandLine gitCmd = Console.createCommand("commit", "-m", message);
        this.runOrBomb(gitCmd);
    }

    @Override
    public void submoduleAdd(String repoUrl, String submoduleNameToPutInGitSubmodules, String folder) {
        String[] addSubmoduleWithSameNameArgs = new String[]{"submodule", "add", repoUrl, folder};
        this.runOrBomb(Console.createCommand(addSubmoduleWithSameNameArgs));
        String[] changeSubmoduleNameInGitModules = new String[]{"config", "--file", ".gitmodules", "--rename-section", "submodule." + folder, "submodule." + submoduleNameToPutInGitSubmodules};
        this.runOrBomb(Console.createCommand(changeSubmoduleNameInGitModules));
        String[] addGitModules = new String[]{"add", ".gitmodules"};
        this.runOrBomb(Console.createCommand(addGitModules));
    }

    @Override
    public void removeSubmoduleSectionsFromGitConfig() {
        this.stdOut.consumeLine("[GIT] Cleaning submodule configurations in .git/config");
        for (String submoduleFolder : this.submoduleUrls().keySet()) {
            this.configRemoveSection("submodule." + submoduleFolder);
        }
    }

    @Override
    public void submoduleRemove(String folderName) {
        this.configRemoveSection("submodule." + folderName);
        CommandLine gitConfig = Console.createCommand("config", "-f", ".gitmodules", "--remove-section", "submodule." + folderName);
        this.runOrBomb(gitConfig);
        CommandLine gitRm = Console.createCommand("rm", "--cached", folderName);
        this.runOrBomb(gitRm);
        FileUtils.deleteQuietly((File)new File(this.workingDir, folderName));
    }

    private void configRemoveSection(String section) {
        CommandLine gitCmd = Console.createCommand("config", "--remove-section", section);
        this.runOrBomb(gitCmd);
    }

    @Override
    public void changeSubmoduleUrl(String submoduleName, String newUrl) {
        CommandLine gitConfig = Console.createCommand("config", "--file", ".gitmodules", "submodule." + submoduleName + ".url", newUrl);
        this.runOrBomb(gitConfig);
    }

    @Override
    public void push() {
        CommandLine gitCommit = Console.createCommand("push");
        this.runOrBomb(gitCommit);
    }

    private ConsoleResult runOrBomb(CommandLine gitCmd) {
        return this.runAndGetOutput(gitCmd, this.workingDir, this.stdOut, this.stdErr);
    }

    private ConsoleResult runAndGetOutput(CommandLine gitCmd) {
        return this.runAndGetOutput(gitCmd, this.workingDir);
    }

    private ConsoleResult runAndGetOutput(CommandLine gitCmd, File workingDir) {
        return this.runAndGetOutput(gitCmd, workingDir, new ProcessOutputStreamConsumer(new InMemoryConsumer()), new ProcessOutputStreamConsumer(new InMemoryConsumer()));
    }

    private ConsoleResult runAndGetOutput(CommandLine gitCmd, File workingDir, ProcessOutputStreamConsumer stdOut, ProcessOutputStreamConsumer stdErr) {
        return Console.runOrBomb(gitCmd, workingDir, stdOut, stdErr);
    }
}

