/*
 * Decompiled with CFR 0.152.
 */
package com.tw.go.plugin;

import com.tw.go.plugin.cmd.ProcessOutputStreamConsumer;
import com.tw.go.plugin.model.GitConfig;
import com.tw.go.plugin.model.Revision;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public abstract class GitHelper {
    protected GitConfig gitConfig;
    protected File workingDir;
    protected ProcessOutputStreamConsumer stdOut;
    protected ProcessOutputStreamConsumer stdErr;

    public GitHelper(GitConfig gitConfig, File workingDir, ProcessOutputStreamConsumer stdOut, ProcessOutputStreamConsumer stdErr) {
        this.gitConfig = gitConfig;
        this.workingDir = workingDir;
        this.stdOut = stdOut;
        this.stdErr = stdErr;
    }

    public abstract String version();

    public abstract void checkConnection();

    public void cloneOrFetch() {
        this.cloneOrFetch(null);
    }

    public void cloneOrFetch(String refSpec) {
        if (!this.isGitRepository() || !this.isSameRepository()) {
            this.setupWorkingDir();
            this.cloneRepository();
        }
        this.fetchAndResetToHead(refSpec);
    }

    private boolean isGitRepository() {
        File dotGit = new File(this.workingDir, ".git");
        return this.workingDir.exists() && dotGit.exists() && dotGit.isDirectory();
    }

    public boolean isSameRepository() {
        try {
            return this.workingRepositoryUrl().equals(this.gitConfig.getEffectiveUrl());
        }
        catch (Exception e) {
            return false;
        }
    }

    private void setupWorkingDir() {
        FileUtils.deleteQuietly((File)this.workingDir);
        try {
            FileUtils.forceMkdir((File)this.workingDir);
        }
        catch (IOException e) {
            new RuntimeException("Could not create directory: " + this.workingDir.getAbsolutePath());
        }
    }

    public abstract void cloneRepository();

    public abstract void checkoutRemoteBranchToLocal();

    public abstract String workingRepositoryUrl();

    public abstract String getCurrentBranch();

    public abstract int getCommitCount();

    public abstract String currentRevision();

    public abstract List<Revision> getAllRevisions();

    public abstract Revision getLatestRevision();

    public abstract List<Revision> getRevisionsSince(String var1);

    public abstract Revision getDetailsForRevision(String var1);

    public Map<String, String> getBranchToRevisionMap() {
        return this.getBranchToRevisionMap("refs/remotes/origin/");
    }

    public abstract Map<String, String> getBranchToRevisionMap(String var1);

    public abstract void pull();

    public abstract void fetch(String var1);

    public abstract void resetHard(String var1);

    public void fetchAndResetToHead(String refSpec) {
        this.fetchAndReset(refSpec, this.gitConfig.getRemoteBranch());
    }

    public void fetchAndReset(String refSpec, String revision) {
        this.stdOut.consumeLine(String.format("[GIT] Fetch and reset in working directory %s", this.workingDir));
        this.cleanAllUnversionedFiles();
        if (this.isSubmoduleEnabled()) {
            this.removeSubmoduleSectionsFromGitConfig();
        }
        this.checkoutRemoteBranchToLocal();
        this.fetch(refSpec);
        this.gc();
        this.resetHard(revision);
        if (this.isSubmoduleEnabled()) {
            this.checkoutAllModifiedFilesInSubmodules();
            this.updateSubmoduleWithInit();
        }
        this.cleanAllUnversionedFiles();
    }

    public abstract void cleanAllUnversionedFiles();

    public abstract void gc();

    public boolean isSubmoduleEnabled() {
        return new File(this.workingDir, ".gitmodules").exists();
    }

    public abstract Map<String, String> submoduleUrls();

    public abstract List<String> submoduleFolders();

    public abstract void printSubmoduleStatus();

    public abstract void checkoutAllModifiedFilesInSubmodules();

    public abstract int getSubModuleCommitCount(String var1);

    public void updateSubmoduleWithInit() {
        this.stdOut.consumeLine("[GIT] Updating git sub-modules");
        this.submoduleInit();
        this.submoduleSync();
        this.submoduleUpdate();
        this.stdOut.consumeLine("[GIT] Cleaning unversioned files and sub-modules");
        this.printSubmoduleStatus();
    }

    public abstract void submoduleInit();

    public abstract void submoduleSync();

    public abstract void submoduleUpdate();

    public abstract void init();

    public abstract void add(File var1);

    public abstract void commit(String var1);

    public abstract void commitOnDate(String var1, Date var2);

    public abstract void submoduleAdd(String var1, String var2, String var3);

    public abstract void removeSubmoduleSectionsFromGitConfig();

    public abstract void submoduleRemove(String var1);

    public abstract void changeSubmoduleUrl(String var1, String var2);

    public abstract void push();
}

