/*
 * Decompiled with CFR 0.152.
 */
package in.ankushs.dbip.model;

import in.ankushs.dbip.api.GeoEntity;
import in.ankushs.dbip.model.GeoAttributes;
import java.net.InetAddress;

public final class GeoAttributesImpl
implements GeoAttributes {
    private final String city;
    private final String country;
    private final String province;
    private final String countryCode;
    private final InetAddress startInetAddress;
    private final InetAddress endInetAddress;

    private GeoAttributesImpl(Builder builder) {
        this.startInetAddress = builder.startInetAddress;
        this.endInetAddress = builder.endInetAddress;
        this.city = builder.city;
        this.country = builder.country;
        this.province = builder.province;
        this.countryCode = builder.countryCode;
    }

    @Override
    public InetAddress getStartInetAddress() {
        return this.startInetAddress;
    }

    @Override
    public InetAddress getEndInetAddress() {
        return this.endInetAddress;
    }

    @Override
    public GeoEntity getGeoEntity() {
        return new GeoEntity.Builder().withCity(this.city).withCountry(this.country).withCountryCode(this.countryCode).withProvince(this.province).build();
    }

    public static class Builder {
        private InetAddress startInetAddress;
        private InetAddress endInetAddress;
        private String city;
        private String country;
        private String province;
        private String countryCode;

        public Builder withStartInetAddress(InetAddress startInetAddress) {
            this.startInetAddress = startInetAddress;
            return this;
        }

        public Builder withCountryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public Builder withEndInetAddress(InetAddress endInetAddress) {
            this.endInetAddress = endInetAddress;
            return this;
        }

        public Builder withCity(String city) {
            this.city = city;
            return this;
        }

        public Builder withCountry(String country) {
            this.country = country;
            return this;
        }

        public Builder withProvince(String province) {
            this.province = province;
            return this;
        }

        public GeoAttributesImpl build() {
            return new GeoAttributesImpl(this);
        }
    }
}

