/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.jpegdecoder;

import de.matthiasmann.jpegdecoder.Component;
import de.matthiasmann.jpegdecoder.Huffman;
import de.matthiasmann.jpegdecoder.IDCT_2D;
import de.matthiasmann.jpegdecoder.YUVDecoder;
import de.matthiasmann.jpegdecoder.YUVtoRGBA;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;

public class JPEGDecoder {
    static final int MARKER_NONE = 255;
    private final InputStream is;
    private final byte[] inputBuffer;
    private int inputBufferPos;
    private int inputBufferValid;
    private boolean ignoreIOerror;
    private boolean headerDecoded;
    private boolean insideSOS;
    private boolean foundEOI;
    private int currentMCURow;
    private final IDCT_2D idct2D;
    private final short[] data;
    private final Huffman[] huffmanTables;
    private final byte[][] dequant;
    private Component[] components;
    private Component[] order;
    private int codeBuffer;
    private int codeBits;
    private int marker = 255;
    private int restartInterval;
    private int todo;
    private int mcuCountX;
    private int mcuCountY;
    private int imageWidth;
    private int imageHeight;
    private int imgHMax;
    private int imgVMax;
    private boolean nomore;
    private byte[][] decodeTmp;
    private byte[][] upsampleTmp;
    static final char[] dezigzag = "\u0000\u0001\b\u0010\t\u0002\u0003\n\u0011\u0018 \u0019\u0012\u000b\u0004\u0005\f\u0013\u001a!(0)\"\u001b\u0014\r\u0006\u0007\u000e\u0015\u001c#*1892+$\u001d\u0016\u000f\u0017\u001e%,3:;4-&\u001f'.5<=6/7>????????????????".toCharArray();

    public JPEGDecoder(InputStream is) {
        this.is = is;
        this.inputBuffer = new byte[4096];
        this.idct2D = new IDCT_2D();
        this.data = new short[64];
        this.huffmanTables = new Huffman[8];
        this.dequant = new byte[4][64];
    }

    public boolean isIgnoreIOerror() {
        return this.ignoreIOerror;
    }

    public void setIgnoreIOerror(boolean ignoreIOerror) {
        if (this.headerDecoded) {
            throw new IllegalStateException("header already decoded");
        }
        this.ignoreIOerror = ignoreIOerror;
    }

    public void decodeHeader() throws IOException {
        if (!this.headerDecoded) {
            this.headerDecoded = true;
            int m = this.getMarker();
            if (m != 216) {
                throw new IOException("no SOI");
            }
            m = this.getMarker();
            while (m != 192 && m != 193) {
                this.processMarker(m);
                m = this.getMarker();
                while (m == 255) {
                    m = this.getMarker();
                }
            }
            this.processSOF();
        }
    }

    public int getImageWidth() {
        this.ensureHeaderDecoded();
        return this.imageWidth;
    }

    public int getImageHeight() {
        this.ensureHeaderDecoded();
        return this.imageHeight;
    }

    public int getNumComponents() {
        this.ensureHeaderDecoded();
        return this.components.length;
    }

    public Component getComponent(int idx) {
        this.ensureHeaderDecoded();
        return this.components[idx];
    }

    public int getMCURowHeight() {
        this.ensureHeaderDecoded();
        return this.imgVMax * 8;
    }

    public int getNumMCURows() {
        this.ensureHeaderDecoded();
        return this.mcuCountY;
    }

    public int getNumMCUColumns() {
        this.ensureHeaderDecoded();
        return this.mcuCountX;
    }

    public boolean startDecode() throws IOException {
        if (this.insideSOS) {
            throw new IllegalStateException("decode already started");
        }
        if (this.foundEOI) {
            return false;
        }
        this.decodeHeader();
        int m = this.getMarker();
        while (m != 217) {
            if (m == 218) {
                this.processScanHeader();
                this.insideSOS = true;
                this.currentMCURow = 0;
                this.reset();
                return true;
            }
            this.processMarker(m);
            m = this.getMarker();
        }
        this.foundEOI = true;
        return false;
    }

    @Deprecated
    public void decodeRGB(ByteBuffer dst, int stride, int numMCURows) throws IOException {
        this.decode(dst, stride, numMCURows, YUVtoRGBA.instance);
    }

    public void decode(ByteBuffer dst, int stride, int numMCURows, YUVDecoder decoder) throws IOException {
        if (decoder == null) {
            throw new NullPointerException("decoder");
        }
        if (!this.insideSOS) {
            throw new IllegalStateException("decode not started");
        }
        if (numMCURows <= 0 || this.currentMCURow + numMCURows > this.mcuCountY) {
            throw new IllegalArgumentException("numMCURows");
        }
        if (this.order.length != 3) {
            throw new UnsupportedOperationException("RGB decode only supported for 3 channels");
        }
        int YUVstride = this.mcuCountX * this.imgHMax * 8;
        boolean requiresUpsampling = this.allocateDecodeTmp(YUVstride);
        byte[] YtoRGB = this.order[0].upsampler != 0 ? this.upsampleTmp[0] : this.decodeTmp[0];
        byte[] UtoRGB = this.order[1].upsampler != 0 ? this.upsampleTmp[1] : this.decodeTmp[1];
        byte[] VtoRGB = this.order[2].upsampler != 0 ? this.upsampleTmp[2] : this.decodeTmp[2];
        for (int j = 0; j < numMCURows; ++j) {
            this.decodeMCUrow();
            if (requiresUpsampling) {
                this.doUpsampling(YUVstride);
            }
            int outPos = dst.position();
            int n = this.imgVMax * 8;
            n = Math.min(this.imageHeight - (this.currentMCURow - 1) * n, n);
            for (int i = 0; i < n; ++i) {
                decoder.decode(dst, outPos, YtoRGB, UtoRGB, VtoRGB, i * YUVstride, this.imageWidth);
                outPos += stride;
            }
            dst.position(outPos);
            if (this.marker != 255) break;
        }
        this.checkDecodeEnd();
    }

    public void decodeRAW(ByteBuffer[] buffer, int[] strides, int numMCURows) throws IOException {
        int compIdx;
        if (!this.insideSOS) {
            throw new IllegalStateException("decode not started");
        }
        if (numMCURows <= 0 || this.currentMCURow + numMCURows > this.mcuCountY) {
            throw new IllegalArgumentException("numMCURows");
        }
        int scanN = this.order.length;
        if (scanN != this.components.length) {
            throw new UnsupportedOperationException("for RAW decode all components need to be decoded at once");
        }
        if (scanN > buffer.length || scanN > strides.length) {
            throw new IllegalArgumentException("not enough buffers");
        }
        for (compIdx = 0; compIdx < scanN; ++compIdx) {
            this.order[compIdx].outPos = buffer[compIdx].position();
        }
        block3: for (int j = 0; j < numMCURows; ++j) {
            ++this.currentMCURow;
            for (int i = 0; i < this.mcuCountX; ++i) {
                for (int compIdx2 = 0; compIdx2 < scanN; ++compIdx2) {
                    Component c = this.order[compIdx2];
                    int outStride = strides[compIdx2];
                    int outPosY = c.outPos + 8 * (i * c.blocksPerMCUHorz + j * c.blocksPerMCUVert * outStride);
                    int y = 0;
                    while (y < c.blocksPerMCUVert) {
                        int x = 0;
                        int outPos = outPosY;
                        while (x < c.blocksPerMCUHorz) {
                            try {
                                this.decodeBlock(this.data, c);
                            }
                            catch (ArrayIndexOutOfBoundsException ex) {
                                JPEGDecoder.throwBadHuffmanCode();
                            }
                            this.idct2D.compute(buffer[compIdx2], outPos, outStride, this.data);
                            ++x;
                            outPos += 8;
                        }
                        ++y;
                        outPosY += 8 * outStride;
                    }
                }
                if (--this.todo <= 0 && !this.checkRestart()) break block3;
            }
        }
        this.checkDecodeEnd();
        for (compIdx = 0; compIdx < scanN; ++compIdx) {
            Component c = this.order[compIdx];
            buffer[compIdx].position(c.outPos + numMCURows * c.blocksPerMCUVert * 8 * strides[compIdx]);
        }
    }

    public void decodeDCTCoeffs(ShortBuffer[] buffer, int numMCURows) throws IOException {
        int compIdx;
        if (!this.insideSOS) {
            throw new IllegalStateException("decode not started");
        }
        if (numMCURows <= 0 || this.currentMCURow + numMCURows > this.mcuCountY) {
            throw new IllegalArgumentException("numMCURows");
        }
        int scanN = this.order.length;
        if (scanN != this.components.length) {
            throw new UnsupportedOperationException("for RAW decode all components need to be decoded at once");
        }
        if (scanN > buffer.length) {
            throw new IllegalArgumentException("not enough buffers");
        }
        for (compIdx = 0; compIdx < scanN; ++compIdx) {
            this.order[compIdx].outPos = buffer[compIdx].position();
        }
        block3: for (int j = 0; j < numMCURows; ++j) {
            ++this.currentMCURow;
            for (int i = 0; i < this.mcuCountX; ++i) {
                for (int compIdx2 = 0; compIdx2 < scanN; ++compIdx2) {
                    Component c = this.order[compIdx2];
                    ShortBuffer sb = buffer[compIdx2];
                    int outStride = 64 * c.blocksPerMCUHorz * this.mcuCountX;
                    int outPos = c.outPos + 64 * i * c.blocksPerMCUHorz + j * c.blocksPerMCUVert * outStride;
                    for (int y = 0; y < c.blocksPerMCUVert; ++y) {
                        sb.position(outPos);
                        for (int x = 0; x < c.blocksPerMCUHorz; ++x) {
                            try {
                                this.decodeBlock(this.data, c);
                            }
                            catch (ArrayIndexOutOfBoundsException ex) {
                                JPEGDecoder.throwBadHuffmanCode();
                            }
                            sb.put(this.data);
                        }
                        outPos += outStride;
                    }
                }
                if (--this.todo <= 0 && !this.checkRestart()) break block3;
            }
        }
        this.checkDecodeEnd();
        for (compIdx = 0; compIdx < scanN; ++compIdx) {
            Component c = this.order[compIdx];
            int outStride = 64 * c.blocksPerMCUHorz * this.mcuCountX;
            buffer[compIdx].position(c.outPos + numMCURows * c.blocksPerMCUVert * outStride);
        }
    }

    private void checkDecodeEnd() throws IOException {
        if (this.currentMCURow >= this.mcuCountY || this.marker != 255) {
            this.insideSOS = false;
            if (this.marker == 255) {
                this.skipPadding();
            }
        }
    }

    private void fetch() throws IOException {
        block3: {
            try {
                this.inputBufferPos = 0;
                this.inputBufferValid = this.is.read(this.inputBuffer);
                if (this.inputBufferValid <= 0) {
                    throw new EOFException();
                }
            }
            catch (IOException ex) {
                this.inputBufferValid = 2;
                this.inputBuffer[0] = -1;
                this.inputBuffer[1] = -39;
                if (this.ignoreIOerror) break block3;
                throw ex;
            }
        }
    }

    private void read(byte[] buf, int off, int len) throws IOException {
        while (len > 0) {
            int avail = this.inputBufferValid - this.inputBufferPos;
            if (avail == 0) {
                this.fetch();
                continue;
            }
            int copy = avail > len ? len : avail;
            System.arraycopy(this.inputBuffer, this.inputBufferPos, buf, off, copy);
            off += copy;
            len -= copy;
            this.inputBufferPos += copy;
        }
    }

    private int getU8() throws IOException {
        if (this.inputBufferPos == this.inputBufferValid) {
            this.fetch();
        }
        return this.inputBuffer[this.inputBufferPos++] & 0xFF;
    }

    private int getU16() throws IOException {
        int t = this.getU8();
        return t << 8 | this.getU8();
    }

    private void skip(int amount) throws IOException {
        while (amount > 0) {
            int inputBufferRemaining = this.inputBufferValid - this.inputBufferPos;
            if (amount > inputBufferRemaining) {
                amount -= inputBufferRemaining;
                this.fetch();
                continue;
            }
            this.inputBufferPos += amount;
            return;
        }
    }

    private void growBufferCheckMarker() throws IOException {
        int c = this.getU8();
        if (c != 0) {
            this.marker = c;
            this.nomore = true;
        }
    }

    private void growBufferUnsafe() throws IOException {
        do {
            int b = 0;
            if (!this.nomore && (b = this.getU8()) == 255) {
                this.growBufferCheckMarker();
            }
            this.codeBuffer |= b << 24 - this.codeBits;
            this.codeBits += 8;
        } while (this.codeBits <= 24);
    }

    private int decode(Huffman h) throws IOException {
        int k;
        if (this.codeBits < 16) {
            this.growBufferUnsafe();
        }
        if ((k = h.fast[this.codeBuffer >>> 23] & 0xFF) < 255) {
            byte s = h.size[k];
            this.codeBuffer <<= s;
            this.codeBits -= s;
            return h.values[k] & 0xFF;
        }
        return this.decodeSlow(h);
    }

    private int decodeSlow(Huffman h) throws IOException {
        int temp = this.codeBuffer >>> 16;
        int s = 10;
        while (temp >= h.maxCode[s]) {
            ++s;
        }
        int k = (temp >>> 16 - s) + h.delta[s];
        this.codeBuffer <<= s;
        this.codeBits -= s;
        return h.values[k] & 0xFF;
    }

    private int extendReceive(int n) throws IOException {
        if (this.codeBits < 24) {
            this.growBufferUnsafe();
        }
        int k = this.codeBuffer >>> 32 - n;
        this.codeBuffer <<= n;
        this.codeBits -= n;
        int limit = 1 << n - 1;
        if (k < limit) {
            k -= limit * 2 - 1;
        }
        return k;
    }

    private void decodeBlock(short[] data, Component c) throws IOException {
        Arrays.fill(data, (short)0);
        byte[] dq = c.dequant;
        int t = this.decode(c.huffDC);
        int dc = c.dcPred;
        if (t > 0) {
            c.dcPred = dc += this.extendReceive(t);
        }
        data[0] = (short)(dc * (dq[0] & 0xFF));
        Huffman hac = c.huffAC;
        int k = 1;
        do {
            int rs = this.decode(hac);
            k += rs >> 4;
            int s = rs & 0xF;
            if (s != 0) {
                int v = this.extendReceive(s) * (dq[k] & 0xFF);
                data[JPEGDecoder.dezigzag[k]] = (short)v;
                continue;
            }
            if (rs != 240) break;
        } while (++k < 64);
    }

    private static void throwBadHuffmanCode() throws IOException {
        throw new IOException("Bad huffman code");
    }

    private int getMarker() throws IOException {
        int m = this.marker;
        if (m != 255) {
            this.marker = 255;
            return m;
        }
        m = this.getU8();
        if (m != 255) {
            return 255;
        }
        while ((m = this.getU8()) == 255) {
        }
        return m;
    }

    private void reset() {
        this.codeBits = 0;
        this.codeBuffer = 0;
        this.nomore = false;
        this.marker = 255;
        this.todo = this.restartInterval != 0 ? this.restartInterval : Integer.MAX_VALUE;
        for (Component c : this.components) {
            c.dcPred = 0;
        }
    }

    private boolean checkRestart() throws IOException {
        if (this.codeBits < 24) {
            this.growBufferUnsafe();
        }
        if (this.marker >= 208 && this.marker <= 215) {
            this.reset();
            return true;
        }
        return false;
    }

    private void processMarker(int marker) throws IOException {
        if (marker >= 224 && (marker <= 239 || marker == 254)) {
            int l = this.getU16() - 2;
            if (l < 0) {
                throw new IOException("bad length");
            }
            this.skip(l);
            return;
        }
        switch (marker) {
            case 255: {
                throw new IOException("Expected marker");
            }
            case 194: {
                throw new IOException("Progressive JPEG not supported");
            }
            case 221: {
                if (this.getU16() != 4) {
                    throw new IOException("bad DRI length");
                }
                this.restartInterval = this.getU16();
                break;
            }
            case 219: {
                int l;
                for (l = this.getU16() - 2; l >= 65; l -= 65) {
                    int q = this.getU8();
                    int p = q >> 4;
                    int t = q & 0xF;
                    if (p != 0) {
                        throw new IOException("bad DQT type");
                    }
                    if (t > 3) {
                        throw new IOException("bad DQT table");
                    }
                    this.read(this.dequant[t], 0, 64);
                }
                if (l == 0) break;
                throw new IOException("bad DQT length");
            }
            case 196: {
                int l = this.getU16() - 2;
                while (l > 17) {
                    int q = this.getU8();
                    int tc = q >> 4;
                    int th = q & 0xF;
                    if (tc > 1 || th > 3) {
                        throw new IOException("bad DHT header");
                    }
                    int[] tmp = this.idct2D.tmp2D;
                    for (int i = 0; i < 16; ++i) {
                        tmp[i] = this.getU8();
                    }
                    Huffman h = new Huffman(tmp);
                    int m = h.getNumSymbols();
                    if ((l -= 17 + m) < 0) {
                        throw new IOException("bad DHT length");
                    }
                    this.read(h.values, 0, m);
                    this.huffmanTables[tc * 4 + th] = h;
                }
                if (l == 0) break;
                throw new IOException("bad DHT length");
            }
            default: {
                throw new IOException("Unknown marker: " + Integer.toHexString(marker));
            }
        }
    }

    private void skipPadding() throws IOException {
        int x;
        while ((x = this.getU8()) == 0) {
        }
        if (x == 255) {
            this.marker = this.getU8();
        }
    }

    private void processScanHeader() throws IOException {
        int ls = this.getU16();
        int scanN = this.getU8();
        if (scanN < 1 || scanN > 4) {
            throw new IOException("bad SOS component count");
        }
        if (ls != 6 + 2 * scanN) {
            throw new IOException("bad SOS length");
        }
        this.order = new Component[scanN];
        for (int i = 0; i < scanN; ++i) {
            int id = this.getU8();
            int q = this.getU8();
            for (Component c : this.components) {
                if (c.id != id) continue;
                int hd = q >> 4;
                int ha = q & 0xF;
                if (hd > 3 || ha > 3) {
                    throw new IOException("bad huffman table index");
                }
                c.huffDC = this.huffmanTables[hd];
                c.huffAC = this.huffmanTables[ha + 4];
                if (c.huffDC == null || c.huffAC == null) {
                    throw new IOException("bad huffman table index");
                }
                this.order[i] = c;
                break;
            }
            if (this.order[i] != null) continue;
            throw new IOException("unknown color component");
        }
        if (this.getU8() != 0) {
            throw new IOException("bad SOS");
        }
        this.getU8();
        if (this.getU8() != 0) {
            throw new IOException("bad SOS");
        }
    }

    private void processSOF() throws IOException {
        int lf = this.getU16();
        if (lf < 11) {
            throw new IOException("bad SOF length");
        }
        if (this.getU8() != 8) {
            throw new IOException("only 8 bit JPEG supported");
        }
        this.imageHeight = this.getU16();
        this.imageWidth = this.getU16();
        if (this.imageWidth <= 0 || this.imageHeight <= 0) {
            throw new IOException("Invalid image size");
        }
        int numComps = this.getU8();
        if (numComps != 3 && numComps != 1) {
            throw new IOException("bad component count");
        }
        if (lf != 8 + 3 * numComps) {
            throw new IOException("bad SOF length");
        }
        int hMax = 1;
        int vMax = 1;
        this.components = new Component[numComps];
        for (int i = 0; i < numComps; ++i) {
            Component c = new Component(this.getU8());
            int q = this.getU8();
            int tq = this.getU8();
            c.blocksPerMCUHorz = q >> 4;
            c.blocksPerMCUVert = q & 0xF;
            if (c.blocksPerMCUHorz == 0 || c.blocksPerMCUHorz > 4) {
                throw new IOException("bad H");
            }
            if (c.blocksPerMCUVert == 0 || c.blocksPerMCUVert > 4) {
                throw new IOException("bad V");
            }
            if (tq > 3) {
                throw new IOException("bad TQ");
            }
            c.dequant = this.dequant[tq];
            hMax = Math.max(hMax, c.blocksPerMCUHorz);
            vMax = Math.max(vMax, c.blocksPerMCUVert);
            this.components[i] = c;
        }
        int mcuW = hMax * 8;
        int mcuH = vMax * 8;
        this.imgHMax = hMax;
        this.imgVMax = vMax;
        this.mcuCountX = (this.imageWidth + mcuW - 1) / mcuW;
        this.mcuCountY = (this.imageHeight + mcuH - 1) / mcuH;
        for (int i = 0; i < numComps; ++i) {
            Component c = this.components[i];
            c.width = (this.imageWidth * c.blocksPerMCUHorz + hMax - 1) / hMax;
            c.height = (this.imageHeight * c.blocksPerMCUVert + vMax - 1) / vMax;
            c.minReqWidth = this.mcuCountX * c.blocksPerMCUHorz * 8;
            c.minReqHeight = this.mcuCountY * c.blocksPerMCUVert * 8;
            if (c.blocksPerMCUHorz < hMax) {
                c.upsampler |= 1;
            }
            if (c.blocksPerMCUVert >= vMax) continue;
            c.upsampler |= 2;
        }
    }

    private void ensureHeaderDecoded() throws IllegalStateException {
        if (!this.headerDecoded) {
            throw new IllegalStateException("need to decode header first");
        }
    }

    private boolean allocateDecodeTmp(int YUVstride) {
        if (this.decodeTmp == null) {
            this.decodeTmp = new byte[3][];
        }
        boolean requiresUpsampling = false;
        for (int compIdx = 0; compIdx < 3; ++compIdx) {
            Component c = this.order[compIdx];
            int reqSize = c.minReqWidth * c.blocksPerMCUVert * 8;
            if (this.decodeTmp[compIdx] == null || this.decodeTmp[compIdx].length < reqSize) {
                this.decodeTmp[compIdx] = new byte[reqSize];
            }
            if (c.upsampler == 0) continue;
            if (this.upsampleTmp == null) {
                this.upsampleTmp = new byte[3][];
            }
            int upsampleReq = this.imgVMax * 8 * YUVstride;
            if (this.upsampleTmp[compIdx] == null || this.upsampleTmp[compIdx].length < upsampleReq) {
                this.upsampleTmp[compIdx] = new byte[upsampleReq];
            }
            requiresUpsampling = true;
        }
        return requiresUpsampling;
    }

    private void decodeMCUrow() throws IOException {
        ++this.currentMCURow;
        for (int i = 0; i < this.mcuCountX; ++i) {
            for (int compIdx = 0; compIdx < 3; ++compIdx) {
                Component c = this.order[compIdx];
                int outStride = c.minReqWidth;
                int outPosY = 8 * i * c.blocksPerMCUHorz;
                int y = 0;
                while (y < c.blocksPerMCUVert) {
                    int x = 0;
                    int outPos = outPosY;
                    while (x < c.blocksPerMCUHorz) {
                        try {
                            this.decodeBlock(this.data, c);
                        }
                        catch (ArrayIndexOutOfBoundsException ex) {
                            JPEGDecoder.throwBadHuffmanCode();
                        }
                        this.idct2D.compute(this.decodeTmp[compIdx], outPos, outStride, this.data);
                        ++x;
                        outPos += 8;
                    }
                    ++y;
                    outPosY += 8 * outStride;
                }
            }
            if (--this.todo <= 0 && !this.checkRestart()) break;
        }
    }

    private void doUpsampling(int YUVstride) {
        block5: for (int compIdx = 0; compIdx < 3; ++compIdx) {
            Component c = this.order[compIdx];
            int inStride = c.minReqWidth;
            int height = c.blocksPerMCUVert * 8;
            switch (c.upsampler) {
                case 1: {
                    int i;
                    for (i = 0; i < height; ++i) {
                        JPEGDecoder.upsampleH2(this.upsampleTmp[compIdx], i * YUVstride, this.decodeTmp[compIdx], i * inStride, c.width);
                    }
                    continue block5;
                }
                case 2: {
                    int i;
                    int inPos0 = 0;
                    int inPos1 = 0;
                    for (i = 0; i < height; ++i) {
                        JPEGDecoder.upsampleV2(this.upsampleTmp[compIdx], i * 2 * YUVstride, this.decodeTmp[compIdx], inPos0, inPos1, c.width);
                        JPEGDecoder.upsampleV2(this.upsampleTmp[compIdx], (i * 2 + 1) * YUVstride, this.decodeTmp[compIdx], inPos1, inPos0, c.width);
                        inPos0 = inPos1;
                        inPos1 += inStride;
                    }
                }
                case 3: {
                    int i;
                    int inPos0 = 0;
                    int inPos1 = 0;
                    for (i = 0; i < height; ++i) {
                        JPEGDecoder.upsampleHV2(this.upsampleTmp[compIdx], i * 2 * YUVstride, this.decodeTmp[compIdx], inPos0, inPos1, c.width);
                        JPEGDecoder.upsampleHV2(this.upsampleTmp[compIdx], (i * 2 + 1) * YUVstride, this.decodeTmp[compIdx], inPos1, inPos0, c.width);
                        inPos0 = inPos1;
                        inPos1 += inStride;
                    }
                    continue block5;
                }
            }
        }
    }

    private static void upsampleH2(byte[] out, int outPos, byte[] in, int inPos, int width) {
        if (width == 1) {
            byte by = in[inPos];
            out[outPos + 1] = by;
            out[outPos] = by;
        } else {
            int i0 = in[inPos] & 0xFF;
            int i1 = in[inPos + 1] & 0xFF;
            out[outPos] = (byte)i0;
            out[outPos + 1] = (byte)(i0 * 3 + i1 + 2 >> 2);
            for (int i = 2; i < width; ++i) {
                int i2 = in[inPos + i] & 0xFF;
                int n = i1 * 3 + 2;
                out[outPos + i * 2 - 2] = (byte)(n + i0 >> 2);
                out[outPos + i * 2 - 1] = (byte)(n + i2 >> 2);
                i0 = i1;
                i1 = i2;
            }
            out[outPos + width * 2 - 2] = (byte)(i0 * 3 + i1 + 2 >> 2);
            out[outPos + width * 2 - 1] = (byte)i1;
        }
    }

    private static void upsampleV2(byte[] out, int outPos, byte[] in, int inPos0, int inPos1, int width) {
        for (int i = 0; i < width; ++i) {
            out[outPos + i] = (byte)(3 * (in[inPos0 + i] & 0xFF) + (in[inPos1 + i] & 0xFF) + 2 >> 2);
        }
    }

    private static void upsampleHV2(byte[] out, int outPos, byte[] in, int inPos0, int inPos1, int width) {
        if (width == 1) {
            int i0 = in[inPos0] & 0xFF;
            int i1 = in[inPos1] & 0xFF;
            byte by = (byte)(i0 * 3 + i1 + 2 >> 2);
            out[outPos + 1] = by;
            out[outPos] = by;
        } else {
            int i1 = 3 * (in[inPos0] & 0xFF) + (in[inPos1] & 0xFF);
            out[outPos] = (byte)(i1 + 2 >> 2);
            for (int i = 1; i < width; ++i) {
                int i0 = i1;
                i1 = 3 * (in[inPos0 + i] & 0xFF) + (in[inPos1 + i] & 0xFF);
                out[outPos + i * 2 - 1] = (byte)(3 * i0 + i1 + 8 >> 4);
                out[outPos + i * 2] = (byte)(3 * i1 + i0 + 8 >> 4);
            }
            out[outPos + width * 2 - 1] = (byte)(i1 + 2 >> 2);
        }
    }
}

