/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.jpegdecoder;

import java.io.IOException;
import java.util.Arrays;

class Huffman {
    static final int FAST_BITS = 9;
    static final int FAST_MASK = 511;
    final byte[] fast;
    final byte[] values;
    final byte[] size;
    final int[] maxCode;
    final int[] delta;

    public Huffman(int[] count) throws IOException {
        int i;
        int i2;
        int numSymbols = 0;
        for (i2 = 0; i2 < 16; ++i2) {
            numSymbols += count[i2];
        }
        this.fast = new byte[512];
        this.values = new byte[numSymbols];
        this.size = new byte[numSymbols];
        this.maxCode = new int[18];
        this.delta = new int[17];
        int k = 0;
        for (i2 = 0; i2 < 16; ++i2) {
            for (int j = 0; j < count[i2]; ++j) {
                this.size[k++] = (byte)(i2 + 1);
            }
        }
        int[] code = new int[256];
        int k2 = 0;
        int c = 0;
        for (i = 1; i <= 16; ++i) {
            this.delta[i] = k2 - c;
            if (k2 < numSymbols && this.size[k2] == i) {
                do {
                    code[k2++] = c++;
                } while (k2 < numSymbols && this.size[k2] == i);
                if (c - 1 >= 1 << i) {
                    throw new IOException("Bad code length");
                }
            }
            this.maxCode[i] = c << 16 - i;
            c <<= 1;
        }
        this.maxCode[i] = Integer.MAX_VALUE;
        Arrays.fill(this.fast, (byte)-1);
        for (i = 0; i < k2; ++i) {
            byte s = this.size[i];
            if (s > 9) continue;
            int c2 = code[i] << 9 - s;
            int m = 1 << 9 - s;
            for (int j = 0; j < m; ++j) {
                this.fast[c2 + j] = (byte)i;
            }
        }
    }

    public int getNumSymbols() {
        return this.values.length;
    }
}

