/*
 * Decompiled with CFR 0.152.
 */
package guru.timeseries.client;

import com.google.common.util.concurrent.SettableFuture;
import de.taimos.httputils.WS;
import guru.timeseries.client.AClient;
import guru.timeseries.client.IAsyncClient;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.apache.http.HttpResponse;

final class AsyncClient
extends AClient
implements IAsyncClient {
    private final Executor executor;
    private final String token;
    private final String databaseID;
    private final int timeout;
    private final String apiBase;
    private final String auth;

    public AsyncClient(Executor executor, String apiBase, String token, String databaseID, int timeout) {
        this.executor = executor;
        this.token = token;
        this.databaseID = databaseID;
        this.timeout = timeout;
        this.apiBase = apiBase;
        this.auth = "Token " + this.token;
    }

    private Future<Void> send(final String timeseriesName, final String csv) {
        final SettableFuture future = SettableFuture.create();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    HttpResponse res = WS.url((String)(AsyncClient.this.apiBase + "/databases/{databaseID}/timeseries/{timeseriesName}/data")).pathParam("databaseID", AsyncClient.this.databaseID).pathParam("timeseriesName", timeseriesName).auth(AsyncClient.this.auth).timeout(AsyncClient.this.timeout).body(csv).contentType("text/csv").post();
                    int status = WS.getStatus((HttpResponse)res);
                    if (status != 204) {
                        throw new Exception("unexpected status code " + status);
                    }
                    future.set(null);
                }
                catch (Exception e) {
                    future.setException((Throwable)e);
                }
            }
        });
        return future;
    }

    @Override
    public Future<Void> insert(String timeseriesName, float value) {
        return this.send(timeseriesName, Float.toString(value));
    }

    @Override
    public Future<Void> insert(String timeseriesName, String symbol, float value) {
        return this.send(timeseriesName, symbol + "," + Float.toString(value));
    }

    @Override
    public IAsyncClient.IAsyncBulkInsert bulk() {
        return new IAsyncClient.IAsyncBulkInsert(){
            private final StringBuilder body = new StringBuilder();

            @Override
            public IAsyncClient.IAsyncBulkInsert add(String timeseriesName, float value) {
                this.body.append(timeseriesName);
                this.body.append(",");
                this.body.append(Float.toString(value));
                this.body.append("\n");
                return this;
            }

            @Override
            public IAsyncClient.IAsyncBulkInsert add(String timeseriesName, String symbol, float value) {
                this.body.append(timeseriesName);
                this.body.append(",");
                this.body.append(symbol);
                this.body.append(",");
                this.body.append(Float.toString(value));
                this.body.append("\n");
                return this;
            }

            @Override
            public Future<Void> insert() {
                final SettableFuture future = SettableFuture.create();
                final String body = this.body.toString();
                if (body.length() == 0) {
                    future.set(null);
                    return future;
                }
                AsyncClient.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            HttpResponse res = WS.url((String)(AsyncClient.this.apiBase + "/databases/{databaseID}/data")).pathParam("databaseID", AsyncClient.this.databaseID).auth(AsyncClient.this.auth).timeout(AsyncClient.this.timeout).body(body.toString()).contentType("text/csv").post();
                            int status = WS.getStatus((HttpResponse)res);
                            if (status != 204) {
                                throw new Exception("unexpected status code " + status);
                            }
                            future.set(null);
                        }
                        catch (Exception e) {
                            future.setException((Throwable)e);
                        }
                    }
                });
                return future;
            }
        };
    }
}

