/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.service;

import guru.nidi.graphviz.service.CommandRunner;
import guru.nidi.graphviz.service.DefaultExecutor;
import guru.nidi.graphviz.service.SystemUtils;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.exec.CommandLine;

public class CommandBuilder {
    private boolean shellWrapper;
    private DefaultExecutor cmdExec;

    public CommandBuilder withShellWrapper(boolean shellWrapper) {
        this.shellWrapper = shellWrapper;
        return this;
    }

    public CommandBuilder withCommandExecutor(DefaultExecutor cmdExec) {
        this.cmdExec = cmdExec;
        return this;
    }

    public CommandRunner build() {
        return new CommandRunner(CommandBuilder.getShellWrapperOrDefault(this.shellWrapper), CommandBuilder.getCmdExecutorOrDefault(this.cmdExec));
    }

    private static DefaultExecutor getCmdExecutorOrDefault(DefaultExecutor cmdExec) {
        return cmdExec == null ? new DefaultExecutor() : cmdExec;
    }

    private static Function<CommandLine, CommandLine> getShellWrapperOrDefault(boolean shellWrapper) {
        if (!shellWrapper) {
            return Function.identity();
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return CommandBuilder.getWindowsShellWrapperFunc();
        }
        if (SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_MAC) {
            return CommandBuilder.getLinuxShellWrapperFunc();
        }
        throw new IllegalStateException("Unsupported OS");
    }

    private static Function<CommandLine, CommandLine> getWindowsShellWrapperFunc() {
        return cmd -> new CommandLine("cmd").addArgument("/C").addArguments(cmd.toStrings(), false);
    }

    private static Function<CommandLine, CommandLine> getLinuxShellWrapperFunc() {
        return cmd -> {
            String originalCmd = Stream.concat(Arrays.stream(new String[]{cmd.getExecutable()}), Arrays.stream(cmd.getArguments())).collect(Collectors.joining(" "));
            return new CommandLine("/bin/sh").addArgument("-c").addArgument(originalCmd, false);
        };
    }
}

