/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.model;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.MutableAttributed;
import guru.nidi.graphviz.attribute.SimpleMutableAttributed;
import guru.nidi.graphviz.model.CreationContext;
import guru.nidi.graphviz.model.Link;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.Linkable;
import guru.nidi.graphviz.model.MutableLinkSource;
import guru.nidi.graphviz.model.MutableNode;
import guru.nidi.graphviz.model.MutablePortNode;
import guru.nidi.graphviz.model.Serializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class MutableGraph
implements Linkable,
MutableLinkSource<MutableGraph>,
LinkTarget {
    protected boolean strict;
    protected boolean directed;
    protected boolean cluster;
    protected String name;
    protected final Set<MutableNode> nodes;
    protected final Set<MutableGraph> subgraphs;
    protected final List<Link> links;
    protected final MutableAttributed<MutableGraph> generalAttrs;
    protected final MutableAttributed<MutableGraph> nodeAttrs;
    protected final MutableAttributed<MutableGraph> linkAttrs;
    protected final MutableAttributed<MutableGraph> graphAttrs;

    public MutableGraph() {
        this(false, false, false, "", new LinkedHashSet<MutableNode>(), new LinkedHashSet<MutableGraph>(), new ArrayList<Link>(), null, null, null, null);
        CreationContext.current().ifPresent(ctx -> this.generalAttrs().add((Attributes)ctx.graphs()));
    }

    protected MutableGraph(boolean strict, boolean directed, boolean cluster, String name, LinkedHashSet<MutableNode> nodes, LinkedHashSet<MutableGraph> subgraphs, List<Link> links, Attributes generalAttrs, Attributes nodeAttrs, Attributes linkAttrs, Attributes graphAttrs) {
        this.strict = strict;
        this.directed = directed;
        this.cluster = cluster;
        this.name = name;
        this.nodes = nodes;
        this.subgraphs = subgraphs;
        this.links = links;
        this.generalAttrs = new SimpleMutableAttributed<MutableGraph>(this, generalAttrs);
        this.nodeAttrs = new SimpleMutableAttributed<MutableGraph>(this, nodeAttrs);
        this.linkAttrs = new SimpleMutableAttributed<MutableGraph>(this, linkAttrs);
        this.graphAttrs = new SimpleMutableAttributed<MutableGraph>(this, graphAttrs);
    }

    public MutableGraph copy() {
        return new MutableGraph(this.strict, this.directed, this.cluster, this.name, new LinkedHashSet<MutableNode>(this.nodes), new LinkedHashSet<MutableGraph>(this.subgraphs), new ArrayList<Link>(this.links), this.generalAttrs, this.nodeAttrs, this.linkAttrs, this.graphAttrs);
    }

    public MutableGraph setStrict(boolean strict) {
        this.strict = strict;
        return this;
    }

    public MutableGraph setDirected(boolean directed) {
        this.directed = directed;
        return this;
    }

    public MutableGraph setCluster(boolean cluster) {
        this.cluster = cluster;
        return this;
    }

    public MutableGraph setName(String name) {
        this.name = name;
        return this;
    }

    public MutableGraph add(LinkSource ... sources) {
        for (LinkSource source : sources) {
            this.add(source);
        }
        return this;
    }

    public MutableGraph add(LinkSource source) {
        if (source instanceof MutableNode) {
            this.nodes.add((MutableNode)source);
            return this;
        }
        if (source instanceof MutablePortNode) {
            this.nodes.add(((MutablePortNode)source).node);
            return this;
        }
        if (source instanceof MutableGraph) {
            this.subgraphs.add((MutableGraph)source);
            return this;
        }
        throw new IllegalArgumentException("Unknown source of type " + source.getClass());
    }

    public MutableGraph addLink(LinkTarget ... targets) {
        for (LinkTarget target : targets) {
            this.addLink(target);
        }
        return this;
    }

    @Override
    public MutableGraph addLink(LinkTarget target) {
        Link link = target.linkTo();
        this.links.add(Link.between(this, link.to).with((Attributes)link.attributes));
        return this;
    }

    public Collection<MutableNode> rootNodes() {
        return this.nodes;
    }

    public Collection<MutableNode> nodes() {
        HashSet<MutableNode> ns = new HashSet<MutableNode>();
        for (MutableNode node : this.nodes) {
            this.collectNodes(node, ns);
        }
        return ns;
    }

    private void collectNodes(MutableNode node, Set<MutableNode> visited) {
        if (!visited.contains(node)) {
            visited.add(node);
            for (Link link : node.links()) {
                if (!(link.to instanceof MutablePortNode)) continue;
                this.collectNodes(((MutablePortNode)link.to).node, visited);
            }
        }
    }

    public Collection<MutableGraph> graphs() {
        return this.subgraphs;
    }

    @Override
    public Collection<Link> links() {
        return this.links;
    }

    @Override
    public Link linkTo() {
        return Link.to(this);
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean isDirected() {
        return this.directed;
    }

    public boolean isCluster() {
        return this.cluster;
    }

    public String name() {
        return this.name;
    }

    public MutableAttributed<MutableGraph> generalAttrs() {
        return this.generalAttrs;
    }

    public MutableAttributed<MutableGraph> nodeAttrs() {
        return this.nodeAttrs;
    }

    public MutableAttributed<MutableGraph> linkAttrs() {
        return this.linkAttrs;
    }

    public MutableAttributed<MutableGraph> graphAttrs() {
        return this.graphAttrs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutableGraph graph = (MutableGraph)o;
        if (this.strict != graph.strict) {
            return false;
        }
        if (this.directed != graph.directed) {
            return false;
        }
        if (this.cluster != graph.cluster) {
            return false;
        }
        if (!this.name.equals(graph.name)) {
            return false;
        }
        if (!this.nodes.equals(graph.nodes)) {
            return false;
        }
        if (!this.subgraphs.equals(graph.subgraphs)) {
            return false;
        }
        if (!this.links.equals(graph.links)) {
            return false;
        }
        if (!this.generalAttrs.equals(graph.generalAttrs)) {
            return false;
        }
        if (!this.nodeAttrs.equals(graph.nodeAttrs)) {
            return false;
        }
        if (!this.linkAttrs.equals(graph.linkAttrs)) {
            return false;
        }
        return this.graphAttrs.equals(graph.graphAttrs);
    }

    public int hashCode() {
        int result = this.strict ? 1 : 0;
        result = 31 * result + (this.directed ? 1 : 0);
        result = 31 * result + (this.cluster ? 1 : 0);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.nodes.hashCode();
        result = 31 * result + this.subgraphs.hashCode();
        result = 31 * result + this.links.hashCode();
        result = 31 * result + this.generalAttrs.hashCode();
        result = 31 * result + this.nodeAttrs.hashCode();
        result = 31 * result + this.linkAttrs.hashCode();
        result = 31 * result + this.graphAttrs.hashCode();
        return result;
    }

    public String toString() {
        return new Serializer(this).serialize();
    }
}

