/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;

class Communicator
implements Closeable {
    private final BufferedReader in;
    private final BufferedWriter out;

    public Communicator(InputStream in, OutputStream out) throws UnsupportedEncodingException {
        this.in = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        this.out = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
    }

    public int readLen() throws IOException {
        String line = this.in.readLine();
        return line == null ? 0 : Integer.parseInt(line);
    }

    public String readStatus() throws IOException {
        return this.in.readLine();
    }

    public String readContent(int len) throws IOException {
        char[] buf = new char[len];
        this.in.read(buf);
        return new String(buf);
    }

    public void writeStatus(String status) throws IOException {
        this.out.write(status);
        this.out.newLine();
    }

    public void writeLen(int len) throws IOException {
        this.out.write(Integer.toString(len));
        this.out.newLine();
        this.out.flush();
    }

    public void writeContent(String content) throws IOException {
        this.writeLen(content.length());
        this.out.write(content);
        this.out.newLine();
        this.out.flush();
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

