/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import com.eclipsesource.v8.V8;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8RuntimeException;
import com.eclipsesource.v8.utils.V8ObjectUtils;
import guru.nidi.graphviz.engine.AbstractGraphvizEngine;
import guru.nidi.graphviz.engine.AbstractJsGraphvizEngine;
import guru.nidi.graphviz.engine.GraphvizException;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphvizV8Engine
extends AbstractJsGraphvizEngine {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractGraphvizEngine.class);
    private static final Pattern ABORT = Pattern.compile("^undefined:\\d+: abort");
    private static final Pattern ERROR = Pattern.compile("^undefined:\\d+: (.*?)\n");
    private static ThreadLocal<Env> envs = new ThreadLocal();

    public GraphvizV8Engine() {
        super(true);
    }

    @Override
    public void release() {
        GraphvizV8Engine.releaseThread();
    }

    static void releaseThread() {
        Env env = envs.get();
        if (env != null) {
            env.release();
            envs.remove();
        }
    }

    @Override
    protected void doInit() throws IOException {
        envs.set(new Env(this.jsInitEnv(), this.jsVizCode("1.8.0")));
    }

    @Override
    protected String jsExecute(String call) {
        Env env = envs.get();
        if (env == null) {
            try {
                this.doInit();
            }
            catch (IOException e) {
                throw new GraphvizException("Could not initialize v8 engine for new thread", e);
            }
        }
        return envs.get().execute(call);
    }

    private static class Env {
        final V8 v8;
        final V8Array messages;

        Env(String init, String viz) {
            LOG.info("Starting V8 runtime...");
            this.v8 = V8.createV8Runtime();
            LOG.info("Started V8 runtime. Initializing graphviz...");
            this.v8.executeVoidScript(init);
            this.messages = this.v8.getArray("$$prints");
            this.v8.executeVoidScript(viz);
            LOG.info("Initialized graphviz.");
        }

        String execute(String call) {
            try {
                return this.v8.executeStringScript(call);
            }
            catch (V8RuntimeException e) {
                if (ABORT.matcher(e.getMessage()).find()) {
                    throw new GraphvizException(IntStream.range(0, this.messages.length()).mapToObj(i -> V8ObjectUtils.getValue((V8Array)this.messages, (int)i).toString()).collect(Collectors.joining("\n")));
                }
                Matcher em = ERROR.matcher(e.getMessage());
                if (em.find()) {
                    throw new GraphvizException(em.group(1));
                }
                throw new GraphvizException("Problem executing graphviz", e);
            }
        }

        void release() {
            this.messages.release();
            this.v8.release(true);
        }
    }
}

