/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.model;

import guru.nidi.graphviz.model.Compass;
import guru.nidi.graphviz.model.Link;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.MutableLinkSource;
import guru.nidi.graphviz.model.MutableNode;

public class MutableNodePoint
implements LinkTarget,
MutableLinkSource<MutableNode> {
    protected MutableNode node;
    protected String record;
    protected Compass compass;

    public MutableNodePoint() {
    }

    protected MutableNodePoint(MutableNode node, String record, Compass compass) {
        this.node = node;
        this.record = record;
        this.compass = compass;
    }

    public MutableNodePoint copy() {
        return new MutableNodePoint(this.node.copy(), this.record, this.compass);
    }

    public MutableNodePoint setNode(MutableNode node) {
        this.node = node;
        return this;
    }

    public MutableNodePoint setRecord(String record) {
        this.record = record;
        return this;
    }

    public MutableNodePoint setCompass(Compass compass) {
        this.compass = compass;
        return this;
    }

    @Override
    public MutableNode addLink(LinkTarget target) {
        return this.node.addLink(target);
    }

    @Override
    public Link linkTo() {
        return Link.to(this);
    }

    public MutableNode node() {
        return this.node;
    }

    public String record() {
        return this.record;
    }

    public Compass compass() {
        return this.compass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutableNodePoint nodePoint = (MutableNodePoint)o;
        if (this.node != null ? !this.node.equals(nodePoint.node) : nodePoint.node != null) {
            return false;
        }
        if (this.record != null ? !this.record.equals(nodePoint.record) : nodePoint.record != null) {
            return false;
        }
        return this.compass == nodePoint.compass;
    }

    public int hashCode() {
        int result = this.node != null ? this.node.hashCode() : 0;
        result = 31 * result + (this.record != null ? this.record.hashCode() : 0);
        result = 31 * result + (this.compass != null ? this.compass.hashCode() : 0);
        return result;
    }

    public String toString() {
        return (this.record == null ? "" : this.record) + ":" + (this.compass == null ? "" : this.compass) + ":" + this.node.toString();
    }
}

