/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.model;

import guru.nidi.graphviz.attribute.Attributed;
import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.MapAttributes;
import guru.nidi.graphviz.attribute.MutableAttributed;
import guru.nidi.graphviz.model.Graph;
import guru.nidi.graphviz.model.Label;
import guru.nidi.graphviz.model.Link;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.model.MutableNode;
import guru.nidi.graphviz.model.Serializer;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;

class ImmutableGraph
extends MutableGraph
implements Graph {
    ImmutableGraph() {
    }

    ImmutableGraph(boolean strict, boolean directed, boolean cluster, Label label, LinkedHashSet<MutableNode> nodes, LinkedHashSet<MutableGraph> subgraphs, List<Link> links, MutableAttributed<MutableGraph> attributes, MutableAttributed<MutableGraph> nodeAttributes, MutableAttributed<MutableGraph> linkAttributes, MutableAttributed<MutableGraph> graphAttributes) {
        super(strict, directed, cluster, label, nodes, subgraphs, links, attributes, nodeAttributes, linkAttributes, graphAttributes);
    }

    public ImmutableGraph copyOfMut() {
        return new ImmutableGraph(this.strict, this.directed, this.cluster, this.label, new LinkedHashSet<MutableNode>(this.nodes), new LinkedHashSet<MutableGraph>(this.subgraphs), new ArrayList<Link>(this.links), this.generalAttrs, this.nodeAttrs, this.linkAttrs, this.graphAttrs);
    }

    @Override
    public Graph strict() {
        return (ImmutableGraph)this.copyOfMut().setStrict();
    }

    @Override
    public Graph directed() {
        return (ImmutableGraph)this.copyOfMut().setDirected();
    }

    @Override
    public Graph cluster() {
        return (ImmutableGraph)this.copyOfMut().setCluster();
    }

    @Override
    public Graph labeled(Label label) {
        return (ImmutableGraph)this.copyOfMut().setLabel(label);
    }

    @Override
    public Graph with(LinkSource ... sources) {
        return (ImmutableGraph)this.copyOfMut().add(sources);
    }

    @Override
    public Graph link(LinkTarget ... targets) {
        return (ImmutableGraph)this.copyOfMut().addLink(targets);
    }

    public Graph link(LinkTarget target) {
        return (ImmutableGraph)this.copyOfMut().addLink(target);
    }

    @Override
    public Attributed<Graph> nodeAttr() {
        return new GraphAttributed(MutableGraph::nodeAttrs);
    }

    @Override
    public Attributed<Graph> linkAttr() {
        return new GraphAttributed(MutableGraph::linkAttrs);
    }

    @Override
    public Attributed<Graph> graphAttr() {
        return new GraphAttributed(MutableGraph::graphAttrs);
    }

    @Override
    public Attributed<Graph> generalAttr() {
        return new GraphAttributed(MutableGraph::generalAttrs);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableGraph graph = (ImmutableGraph)o;
        if (this.strict != graph.strict) {
            return false;
        }
        if (this.directed != graph.directed) {
            return false;
        }
        if (this.cluster != graph.cluster) {
            return false;
        }
        if (!this.label.equals(graph.label)) {
            return false;
        }
        if (!this.nodes.equals(graph.nodes)) {
            return false;
        }
        if (!this.subgraphs.equals(graph.subgraphs)) {
            return false;
        }
        if (!this.links.equals(graph.links)) {
            return false;
        }
        if (!this.generalAttrs.equals(graph.generalAttrs)) {
            return false;
        }
        if (!this.nodeAttrs.equals(graph.nodeAttrs)) {
            return false;
        }
        if (!this.linkAttrs.equals(graph.linkAttrs)) {
            return false;
        }
        return this.graphAttrs.equals(graph.graphAttrs);
    }

    @Override
    public int hashCode() {
        int result = this.strict ? 1 : 0;
        result = 31 * result + (this.directed ? 1 : 0);
        result = 31 * result + (this.cluster ? 1 : 0);
        result = 31 * result + this.label.hashCode();
        result = 31 * result + this.nodes.hashCode();
        result = 31 * result + this.subgraphs.hashCode();
        result = 31 * result + this.links.hashCode();
        result = 31 * result + this.generalAttrs.hashCode();
        result = 31 * result + this.nodeAttrs.hashCode();
        result = 31 * result + this.linkAttrs.hashCode();
        result = 31 * result + this.graphAttrs.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return new Serializer(this).serialize();
    }

    private class GraphAttributed
    implements Attributed<Graph> {
        private final Function<ImmutableGraph, MutableAttributed<MutableGraph>> attributeSource;

        public GraphAttributed(Function<ImmutableGraph, MutableAttributed<MutableGraph>> attributeSource) {
            this.attributeSource = attributeSource;
        }

        @Override
        public Graph with(Attributes attrs) {
            return (ImmutableGraph)this.attributeSource.apply(ImmutableGraph.this.copyOfMut()).add(attrs);
        }

        @Override
        public Attributes applyTo(MapAttributes attrs) {
            return this.attributeSource.apply(ImmutableGraph.this).applyTo(attrs);
        }
    }
}

