/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.AbstractGraphvizEngine;
import guru.nidi.graphviz.engine.GraphvizException;
import guru.nidi.graphviz.engine.Options;
import guru.nidi.graphviz.service.CommandBuilder;
import guru.nidi.graphviz.service.CommandRunner;
import guru.nidi.graphviz.service.DefaultExecutor;
import guru.nidi.graphviz.service.SystemUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphvizCmdLineEngine
extends AbstractGraphvizEngine {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractGraphvizEngine.class);
    private final String envPath;
    private final CommandRunner cmdRunner;
    private String dotOutputFilePath;
    private String dotOutputFileName;

    public GraphvizCmdLineEngine() {
        this(Optional.ofNullable(System.getenv("PATH")).orElse(""), new DefaultExecutor());
    }

    public GraphvizCmdLineEngine(String envPath, DefaultExecutor executor) {
        super(true);
        this.envPath = envPath;
        this.cmdRunner = new CommandBuilder().withShellWrapper(true).withCommandExecutor(executor).build();
    }

    @Override
    protected void doInit() throws GraphvizException {
        if (!CommandRunner.isExecutableFound("dot", this.envPath)) {
            throw new GraphvizException("'dot' command not found");
        }
    }

    @Override
    public String execute(String src, Options options) {
        String engine = this.getEngineFromOptions(options);
        if (!CommandRunner.isExecutableFound(engine, this.envPath)) {
            throw new GraphvizException(engine + " command not found");
        }
        try {
            Path tempDirPath = Files.createTempDirectory(this.getOrCreateTempDirectory().toPath(), "DotEngine", new FileAttribute[0]);
            File dotfile = this.getDotFile(tempDirPath.toString());
            try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dotfile), StandardCharsets.UTF_8));){
                bw.write(src);
            }
            String command = engine + " -T" + this.getFormatFromOptions(options) + " " + dotfile.getAbsolutePath() + " -ooutfile.svg";
            this.cmdRunner.exec(command, tempDirPath.toFile(), new String[0]);
            byte[] encoded = Files.readAllBytes(tempDirPath.resolve("outfile.svg"));
            FileUtils.deleteDirectory((File)tempDirPath.toFile());
            return new String(encoded, StandardCharsets.UTF_8);
        }
        catch (IOException | InterruptedException e) {
            throw new GraphvizException(e.getMessage(), e);
        }
    }

    private String getEngineFromOptions(Options options) {
        String engine = "dot";
        if (options.engine != null) {
            engine = options.engine.toString().toLowerCase();
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            engine = engine + ".exe";
        }
        return engine;
    }

    private String getFormatFromOptions(Options options) {
        String format = "svg";
        if (options.format != null && options.format.vizName != null) {
            format = options.format.vizName;
        }
        return format;
    }

    private File getOrCreateTempDirectory() {
        File tempDir = new File(System.getProperty("java.io.tmpdir") + File.separator + "GraphvizJava");
        if (!tempDir.exists() && tempDir.mkdir()) {
            LOG.debug("Created GraphvizJava temporary directory");
        }
        return tempDir;
    }

    private File getDotFile(String tempDirPath) {
        String dotFileName = this.dotOutputFileName == null ? "dotfile.dot" : this.dotOutputFileName + ".dot";
        String baseDir = this.dotOutputFilePath == null ? tempDirPath : this.dotOutputFilePath;
        return new File(baseDir, dotFileName);
    }

    public void setDotOutputFile(String path, String name) {
        this.dotOutputFilePath = path;
        this.dotOutputFileName = name;
    }
}

