/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.attribute.validate;

import java.util.Objects;

public class ValidatorMessage {
    public final Severity severity;
    public final String attribute;
    public final String message;
    public final int line;
    public final int column;

    ValidatorMessage(Severity severity, String message) {
        this(severity, "", message);
    }

    public ValidatorMessage(Severity severity, String attribute, String message) {
        this(severity, attribute, message, 0, 0);
    }

    public ValidatorMessage(Severity severity, String attribute, String message, int line, int column) {
        this.severity = severity;
        this.attribute = attribute;
        this.message = message;
        this.line = line;
        this.column = column;
    }

    public ValidatorMessage at(int line, int column) {
        return new ValidatorMessage(this.severity, this.attribute, this.message, line, column);
    }

    ValidatorMessage at(String attribute) {
        return new ValidatorMessage(this.severity, attribute, this.message, this.line, this.column);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidatorMessage that = (ValidatorMessage)o;
        return this.line == that.line && this.column == that.column && this.severity == that.severity && this.attribute.equals(that.attribute) && this.message.equals(that.message);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.severity, this.attribute, this.message, this.line, this.column});
    }

    public String toString() {
        return "ValidatorMessage{" + this.line + ":" + this.column + " " + (Object)((Object)this.severity) + ", attribute='" + this.attribute + '\'' + ", message='" + this.message + '\'' + '}';
    }

    public static enum Severity {
        ERROR,
        WARNING,
        INFO;

    }
}

