/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.attribute.validate;

import guru.nidi.graphviz.attribute.validate.AttributeValidator;
import guru.nidi.graphviz.attribute.validate.Datatype;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;

final class AttributeConfig {
    final List<Datatype> types;
    @Nullable
    final Object defVal;
    @Nullable
    final Double min;
    final EnumSet<Engine> engines;
    final EnumSet<Format> formats;
    final EnumSet<AttributeValidator.Scope> scopes;

    private AttributeConfig(@Nullable EnumSet<AttributeValidator.Scope> scopes, List<Datatype> types, @Nullable Object defVal, @Nullable Double min, @Nullable EnumSet<Engine> engines, @Nullable EnumSet<Format> formats) {
        this.scopes = scopes == null ? EnumSet.noneOf(AttributeValidator.Scope.class) : scopes;
        this.types = types;
        this.defVal = defVal;
        this.min = min;
        this.engines = engines == null ? EnumSet.noneOf(Engine.class) : engines;
        this.formats = formats == null ? EnumSet.noneOf(Format.class) : formats;
    }

    static AttributeConfig entry(String scopes, Datatype type) {
        return AttributeConfig.entry(scopes, type, null);
    }

    static AttributeConfig entry(String scopes, List<Datatype> types) {
        return AttributeConfig.entry(scopes, types, null);
    }

    static AttributeConfig entry(String scopes, Datatype type, @Nullable Object defVal) {
        return AttributeConfig.entry(scopes, type, defVal, null);
    }

    static AttributeConfig entry(String scopes, List<Datatype> types, @Nullable Object defVal) {
        return AttributeConfig.entry(scopes, types, defVal, null);
    }

    static AttributeConfig entry(String scopes, Datatype type, @Nullable Object defVal, @Nullable Double min) {
        return AttributeConfig.entry(scopes, Collections.singletonList(type), defVal, min);
    }

    static AttributeConfig entry(String scopes, List<Datatype> types, @Nullable Object defVal, @Nullable Double min) {
        return new AttributeConfig(AttributeConfig.scopesOf(scopes), types, defVal, min, null, null);
    }

    AttributeConfig engines(Engine ... engines) {
        return new AttributeConfig(this.scopes, this.types, this.defVal, this.min, EnumSet.of(engines[0], engines), this.formats);
    }

    AttributeConfig formats(Format ... formats) {
        return new AttributeConfig(this.scopes, this.types, this.defVal, this.min, this.engines, EnumSet.of(formats[0], formats));
    }

    private static EnumSet<AttributeValidator.Scope> scopesOf(String scopes) {
        EnumSet<AttributeValidator.Scope> res = EnumSet.noneOf(AttributeValidator.Scope.class);
        block7: for (int i = 0; i < scopes.length(); ++i) {
            switch (scopes.charAt(i)) {
                case 'G': {
                    res.add(AttributeValidator.Scope.GRAPH);
                    continue block7;
                }
                case 'S': {
                    res.add(AttributeValidator.Scope.SUB_GRAPH);
                    continue block7;
                }
                case 'C': {
                    res.add(AttributeValidator.Scope.CLUSTER);
                    continue block7;
                }
                case 'N': {
                    res.add(AttributeValidator.Scope.NODE);
                    continue block7;
                }
                case 'E': {
                    res.add(AttributeValidator.Scope.EDGE);
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("unknown scope '" + scopes.charAt(i) + "'.");
                }
            }
        }
        return res;
    }

    static enum Format {
        WRITE,
        SVG,
        BITMAP,
        MAP,
        CMAP,
        POSTSCRIPT,
        XDOT;

    }

    static enum Engine {
        CIRCO,
        NOT_DOT,
        DOT,
        NEATO,
        OSAGE,
        TWOPI,
        FDP,
        SFDP,
        PATCHWORK;

    }
}

