/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.pmd;

import guru.nidi.codeassert.pmd.CpdResult;
import guru.nidi.codeassert.util.ResultMatcher;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;
import org.hamcrest.Description;

public class CpdMatcher
extends ResultMatcher<CpdResult, Match> {
    private static final Comparator<Mark> MARK_COMPARATOR = Comparator.comparing(Mark::getFilename);

    public void describeTo(Description description) {
        description.appendText("Has no code duplications");
    }

    protected void describeMismatchSafely(CpdResult item, Description description) {
        for (Match match : (List)item.findings()) {
            description.appendText("\n").appendText(this.printMatch(match));
        }
    }

    private String printMatch(Match match) {
        StringBuilder s = new StringBuilder();
        boolean first = true;
        for (Mark mark : this.getMarks(match)) {
            s.append(first ? String.format("%-4d ", match.getTokenCount()) : "     ");
            first = false;
            s.append(String.format("%s:%d-%d%n", mark.getFilename(), mark.getBeginLine(), mark.getEndLine()));
        }
        return s.substring(0, s.length() - 1);
    }

    private List<Mark> getMarks(Match match) {
        ArrayList<Mark> marks = new ArrayList<Mark>();
        Iterator iter = match.iterator();
        while (iter.hasNext()) {
            marks.add((Mark)iter.next());
        }
        marks.sort(MARK_COMPARATOR);
        return marks;
    }
}

