/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.pmd;

import guru.nidi.codeassert.config.ActionResult;
import guru.nidi.codeassert.config.BaseCollector;
import guru.nidi.codeassert.config.CollectorConfig;
import guru.nidi.codeassert.config.Ignore;
import guru.nidi.codeassert.config.Language;
import guru.nidi.codeassert.config.NamedLocation;
import guru.nidi.codeassert.config.UsageCounter;
import guru.nidi.codeassert.pmd.PmdUtils;
import guru.nidi.codeassert.util.ListUtils;
import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;

public class CpdMatchCollector
extends BaseCollector<Match, Ignore, CpdMatchCollector> {
    @Override
    public CpdMatchCollector config(final CollectorConfig<Ignore> ... configs) {
        return new CpdMatchCollector(){

            @Override
            public ActionResult accept(Match issue) {
                return this.accept(issue, CpdMatchCollector.this, configs);
            }

            @Override
            public String toString() {
                return CpdMatchCollector.this.toString() + "\n" + ListUtils.join("\n", configs);
            }
        };
    }

    @Override
    protected ActionResult doAccept(Match issue, Ignore action) {
        ActionResult res = ActionResult.undecided(null);
        for (Mark mark : issue) {
            Language language = Language.byFilename(mark.getFilename());
            res = res.orMoreQuality(action.accept(new NamedLocation(mark.getSourceCodeSlice(), language, PmdUtils.className(mark), "", false)));
        }
        return res;
    }

    @Override
    public ActionResult accept(Match issue) {
        return ActionResult.accept(null, 1);
    }

    @Override
    public List<Ignore> unused(UsageCounter counter) {
        return Collections.emptyList();
    }

    public String toString() {
        return "";
    }
}

