/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.model;

import guru.nidi.codeassert.AnalyzerException;
import guru.nidi.codeassert.model.ClassFileParser;
import guru.nidi.codeassert.model.CodeClass;
import guru.nidi.codeassert.model.CodePackage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;

public class Model {
    public static final String UNNAMED_PACKAGE = "<Unnamed Package>";
    final Map<String, CodePackage> packages = new HashMap<String, CodePackage>();
    final Map<String, CodeClass> classes = new HashMap<String, CodeClass>();

    public static Model from(File ... files) {
        return Model.from(Arrays.asList(files));
    }

    public static Model from(List<File> files) {
        return new Model().and(files);
    }

    public Model and(File ... files) {
        return this.and(Arrays.asList(files));
    }

    public Model and(List<File> files) {
        try {
            ClassFileParser classParser = new ClassFileParser();
            for (File file : files) {
                FileInputStream in = new FileInputStream(file);
                Throwable throwable = null;
                try {
                    this.add(classParser, file.getName(), in);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)in).close();
                }
            }
            return this;
        }
        catch (IOException e) {
            throw new AnalyzerException("Problem creating a Model", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(ClassFileParser parser, String name, InputStream in) throws IOException {
        if (name.endsWith(".jar") || name.endsWith(".zip") || name.endsWith(".war") || name.endsWith(".ear")) {
            ZipEntry entry;
            JarInputStream jar = new JarInputStream(in);
            while ((entry = jar.getNextEntry()) != null) {
                try {
                    if (entry.isDirectory()) continue;
                    this.add(parser, entry.getName(), jar);
                }
                finally {
                    jar.closeEntry();
                }
            }
        } else if (name.endsWith(".class")) {
            parser.parse(in, this);
        }
    }

    CodePackage getOrCreatePackage(String name) {
        CodePackage pack = this.packages.get(name);
        if (pack == null) {
            pack = new CodePackage(name);
            this.packages.put(name, pack);
        }
        return pack;
    }

    CodeClass getOrCreateClass(String name) {
        CodeClass clazz = this.classes.get(name);
        if (clazz == null) {
            CodePackage pack = this.getOrCreatePackage(Model.packageOf(name));
            clazz = new CodeClass(name, pack);
            this.classes.put(name, clazz);
            pack.addClass(clazz);
        }
        return clazz;
    }

    static String packageOf(String type) {
        int pos = type.lastIndexOf(46);
        return pos < 0 ? UNNAMED_PACKAGE : type.substring(0, pos);
    }

    public Collection<CodePackage> getPackages() {
        return this.packages.values();
    }

    public Collection<CodeClass> getClasses() {
        return this.classes.values();
    }
}

