/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.model;

import guru.nidi.codeassert.model.AttributeInfo;
import guru.nidi.codeassert.model.ConstantPool;
import java.io.DataInputStream;
import java.io.IOException;

public final class MemberInfo {
    private final int accessFlags;
    private final String name;
    final String descriptor;
    final AttributeInfo annotations;
    final AttributeInfo signature;
    final int codeSize;

    private MemberInfo(int accessFlags, String name, String descriptor, AttributeInfo annotations, AttributeInfo signature, int codeSize) {
        this.accessFlags = accessFlags;
        this.name = name;
        this.descriptor = descriptor;
        this.annotations = annotations;
        this.signature = signature;
        this.codeSize = codeSize;
    }

    static MemberInfo fromData(DataInputStream in, ConstantPool constantPool) throws IOException {
        int access = in.readUnsignedShort();
        String name = constantPool.getUtf8(in.readUnsignedShort());
        String descriptor = constantPool.getUtf8(in.readUnsignedShort());
        int attributesCount = in.readUnsignedShort();
        AttributeInfo annotations = null;
        AttributeInfo signature = null;
        int codeSize = 0;
        for (int a = 0; a < attributesCount; ++a) {
            AttributeInfo attribute = AttributeInfo.fromData(in, constantPool);
            if (attribute.isAnnotation()) {
                annotations = attribute;
            }
            if (attribute.isSignature()) {
                signature = attribute;
            }
            if (!attribute.isCode()) continue;
            codeSize = attribute.value.length;
        }
        return new MemberInfo(access, name, descriptor, annotations, signature, codeSize);
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public String getName() {
        return this.name;
    }

    public int getCodeSize() {
        return this.codeSize;
    }
}

