/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.model;

import guru.nidi.codeassert.model.Constant;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class ConstantPool
implements Iterable<Constant> {
    private final Constant[] pool;

    private ConstantPool(Constant[] pool) {
        this.pool = pool;
    }

    public static ConstantPool fromData(DataInputStream in) throws IOException {
        int size = in.readUnsignedShort();
        Constant[] pool = new Constant[size];
        for (int i = 1; i < size; ++i) {
            Constant constant;
            pool[i] = constant = Constant.fromData(in);
            if (!constant.isBig()) continue;
            ++i;
        }
        return new ConstantPool(pool);
    }

    public Constant getEntry(int entryIndex) throws IOException {
        if (entryIndex < 0 || entryIndex >= this.pool.length) {
            throw new IOException("Illegal constant pool index : " + entryIndex);
        }
        return this.pool[entryIndex];
    }

    public String getClassConstantName(int entryIndex) throws IOException {
        Constant entry = this.getEntry(entryIndex);
        if (entry == null) {
            return "";
        }
        return this.slashesToDots(this.getUtf8(entry.nameIndex));
    }

    private String slashesToDots(String s) {
        return s.replace('/', '.');
    }

    public String getUtf8(int entryIndex) throws IOException {
        Constant entry = this.getEntry(entryIndex);
        if (entry.tag == 1) {
            return (String)entry.value;
        }
        throw new IOException("Constant pool entry is not a UTF8 type: " + entryIndex);
    }

    @Override
    public Iterator<Constant> iterator() {
        return new Iterator<Constant>(){
            int pos = 1;

            @Override
            public boolean hasNext() {
                return this.pos < ConstantPool.this.pool.length;
            }

            @Override
            public Constant next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Constant constant = ConstantPool.this.pool[this.pos];
                this.pos += constant.isBig() ? 2 : 1;
                return constant;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

