/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.ktlint;

import guru.nidi.codeassert.config.ActionResult;
import guru.nidi.codeassert.config.BaseCollector;
import guru.nidi.codeassert.config.CollectorConfig;
import guru.nidi.codeassert.config.Ignore;
import guru.nidi.codeassert.config.Language;
import guru.nidi.codeassert.config.NamedLocation;
import guru.nidi.codeassert.config.UsageCounter;
import guru.nidi.codeassert.ktlint.LocatedLintError;
import guru.nidi.codeassert.util.ListUtils;
import java.util.List;

public class KtlintCollector
extends BaseCollector<LocatedLintError, Ignore, KtlintCollector> {
    @Override
    public KtlintCollector config(final CollectorConfig<Ignore> ... configs) {
        return new KtlintCollector(){

            @Override
            public ActionResult accept(LocatedLintError issue) {
                return this.accept(issue, KtlintCollector.this, configs);
            }

            @Override
            public List<Ignore> unused(UsageCounter counter) {
                return this.unused(counter, KtlintCollector.this, configs);
            }

            @Override
            public String toString() {
                return KtlintCollector.this.toString() + "\n" + ListUtils.join("\n", configs);
            }
        };
    }

    @Override
    public ActionResult accept(LocatedLintError issue) {
        return ActionResult.accept(null, 1);
    }

    @Override
    protected ActionResult doAccept(LocatedLintError issue, Ignore action) {
        String className = this.guessClassFromFile(issue.file.getAbsolutePath(), Language.KOTLIN);
        Language language = Language.byFilename(issue.file.getName());
        return action.accept(new NamedLocation(issue.ruleId, language, className, null, true));
    }

    @Override
    public List<Ignore> unused(UsageCounter counter) {
        return this.unusedNullAction(counter, false);
    }

    public String toString() {
        return "";
    }
}

