/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.jacoco;

import guru.nidi.codeassert.config.ValuedLocation;
import guru.nidi.codeassert.jacoco.CoverageType;

public class Coverage
implements Comparable<Coverage> {
    final String pack;
    private final String clazz;
    private final int instMissed;
    private final int instCovered;
    private final int branchMissed;
    private final int branchCovered;
    private final int lineMissed;
    private final int lineCovered;
    private final int complexMissed;
    private final int complexCovered;
    private final int methodMissed;
    private final int methodCovered;

    public Coverage(String pack, String clazz, int instMissed, int instCovered, int branchMissed, int branchCovered, int lineMissed, int lineCovered, int complexMissed, int complexCovered, int methodMissed, int methodCovered) {
        this.pack = pack;
        this.clazz = clazz;
        this.instMissed = instMissed;
        this.instCovered = instCovered;
        this.branchMissed = branchMissed;
        this.branchCovered = branchCovered;
        this.lineMissed = lineMissed;
        this.lineCovered = lineCovered;
        this.complexMissed = complexMissed;
        this.complexCovered = complexCovered;
        this.methodMissed = methodMissed;
        this.methodCovered = methodCovered;
    }

    public Coverage combined(Coverage c) {
        return new Coverage(this.pack.equals(c.pack) ? this.pack : "", this.clazz.equals(c.clazz) ? this.clazz : "", this.instMissed + c.instMissed, this.instCovered + c.instCovered, this.branchMissed + c.branchMissed, this.branchCovered + c.branchCovered, this.lineMissed + c.lineMissed, this.lineCovered + c.lineCovered, this.complexCovered + c.complexCovered, this.complexMissed + c.complexMissed, this.methodMissed + c.methodMissed, this.methodCovered + c.methodCovered);
    }

    public Coverage withClazz(String clazz) {
        return new Coverage(this.pack, clazz, this.instMissed, this.instCovered, this.branchMissed, this.branchCovered, this.lineMissed, this.lineCovered, this.complexMissed, this.complexCovered, this.methodMissed, this.methodCovered);
    }

    public ValuedLocation toValuedLocation(CoverageType[] types) {
        return new ValuedLocation(this.pack, this.clazz, this.projection(types));
    }

    public double[] projection(CoverageType[] types) {
        double[] res = new double[types.length];
        for (int i = 0; i < types.length; ++i) {
            res[i] = this.projection(types[i]);
        }
        return res;
    }

    public double projection(CoverageType type) {
        switch (type) {
            case INSTRUCTION: {
                return this.instCoverage();
            }
            case BRANCH: {
                return this.branchCoverage();
            }
            case LINE: {
                return this.lineCoverage();
            }
            case COMPLEXITY: {
                return this.complexCoverage();
            }
            case METHOD: {
                return this.methodCoverage();
            }
        }
        throw new AssertionError((Object)("Unhandled CoverageType " + (Object)((Object)type)));
    }

    public double instCoverage() {
        return this.cover(this.instMissed, this.instCovered);
    }

    public double branchCoverage() {
        return this.cover(this.branchMissed, this.branchCovered);
    }

    public double lineCoverage() {
        return this.cover(this.lineMissed, this.lineCovered);
    }

    public double complexCoverage() {
        return this.cover(this.complexMissed, this.complexCovered);
    }

    public double methodCoverage() {
        return this.cover(this.methodMissed, this.methodCovered);
    }

    private double cover(int missed, int covered) {
        int sum = missed + covered;
        return sum == 0 ? 100.0 : 100.0 * (double)covered / (double)sum;
    }

    @Override
    public int compareTo(Coverage o) {
        return (this.pack + "." + this.clazz).compareToIgnoreCase(o.pack + "." + o.clazz);
    }
}

