/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.findbugs;

import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.PluginException;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.plugins.DuplicatePluginIdException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PluginLoader {
    private static final Logger LOG = LoggerFactory.getLogger(PluginLoader.class);
    private static final List<Plugin> PLUGINS = PluginLoader.loadPlugins();

    private PluginLoader() {
    }

    static void addPluginsTo(Project project) {
        for (Plugin plugin : PLUGINS) {
            project.setPluginStatusTrinary(plugin.getPluginId(), Boolean.valueOf(true));
        }
    }

    private static List<Plugin> loadPlugins() {
        ArrayList<Plugin> res = new ArrayList<Plugin>();
        Enumeration<URL> resources = PluginLoader.findPluginUrls();
        while (resources.hasMoreElements()) {
            try {
                Plugin plugin = Plugin.addCustomPlugin((URL)PluginLoader.jarUrl(resources.nextElement()));
                if (plugin == null) continue;
                res.add(plugin);
                LOG.info("Loaded plugin {}", (Object)plugin.getPluginId());
            }
            catch (DuplicatePluginIdException plugin) {
            }
            catch (PluginException | MalformedURLException e) {
                LOG.warn("Problem loading plugin", e);
            }
        }
        return res;
    }

    private static Enumeration<URL> findPluginUrls() {
        try {
            return Thread.currentThread().getContextClassLoader().getResources("findbugs.xml");
        }
        catch (IOException e) {
            return new Vector().elements();
        }
    }

    private static URL jarUrl(URL url) throws MalformedURLException {
        String s = url.toString();
        if (!s.startsWith("jar:file:")) {
            throw new MalformedURLException("Cannot handle plugin URL " + url);
        }
        int pos = s.indexOf(".jar!/");
        return new URL(s.substring(4, pos) + ".jar");
    }
}

