/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugRanker;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import guru.nidi.codeassert.config.AnalyzerConfig;
import guru.nidi.codeassert.config.Language;
import guru.nidi.codeassert.findbugs.FindBugsAnalyzer;
import guru.nidi.codeassert.findbugs.FindBugsResult;
import guru.nidi.codeassert.util.ResultMatcher;
import java.io.File;
import java.util.List;
import org.hamcrest.Description;

public class FindBugsMatcher
extends ResultMatcher<FindBugsResult, BugInstance> {
    public void describeTo(Description description) {
        description.appendText("Has no FindBugs issues");
    }

    protected void describeMismatchSafely(FindBugsResult item, Description description) {
        for (BugInstance bug : (List)item.findings()) {
            description.appendText("\n").appendText(this.printBug(bug, ((FindBugsAnalyzer)item.analyzer()).config.getSourcePaths(new Language[0])));
        }
    }

    private String printBug(BugInstance bug, List<AnalyzerConfig.Path> sources) {
        int rank = BugRanker.findRank((BugInstance)bug);
        SourceLineAnnotation line = bug.getPrimarySourceLineAnnotation();
        int startLine = line.getStartLine() <= 0 ? 0 : line.getStartLine();
        String msg = bug.getMessage();
        int pos = msg.indexOf(58);
        String message = msg.substring(pos + 2).replace('\n', ' ');
        return String.format("%2d %-8s %-45s %s:%d    %s", rank, this.priority(bug), bug.getType(), this.sourcePath(line.getSourcePath(), sources), startLine, message);
    }

    private String sourcePath(String sourcePath, List<AnalyzerConfig.Path> sources) {
        for (AnalyzerConfig.Path source : sources) {
            File file = new File(source.getBase(), sourcePath);
            if (!file.exists()) continue;
            return file.getAbsolutePath();
        }
        return sourcePath;
    }

    private String priority(BugInstance bug) {
        switch (bug.getPriority()) {
            case 4: {
                return "E";
            }
            case 3: {
                return "L";
            }
            case 2: {
                return "M";
            }
            case 1: {
                return "H";
            }
        }
        return "?";
    }
}

