/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.detekt;

import guru.nidi.codeassert.Analyzer;
import guru.nidi.codeassert.config.AnalyzerConfig;
import guru.nidi.codeassert.config.Language;
import guru.nidi.codeassert.config.UsageCounter;
import guru.nidi.codeassert.detekt.DetektCollector;
import guru.nidi.codeassert.detekt.DetektResult;
import guru.nidi.codeassert.detekt.TypedDetektFinding;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Detektion;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.RuleSetProvider;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.YamlConfig;
import io.gitlab.arturbosch.detekt.core.DetektFacade;
import io.gitlab.arturbosch.detekt.core.ProcessingSettings;
import io.gitlab.arturbosch.detekt.core.RuleSetLocator;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetektAnalyzer
implements Analyzer<List<TypedDetektFinding>> {
    private static final Logger LOG = LoggerFactory.getLogger(DetektAnalyzer.class);
    private static final List<Severity> SEVERITIES = Arrays.asList(Severity.Style, Severity.CodeSmell, Severity.Minor, Severity.Performance, Severity.Maintainability, Severity.Warning, Severity.Security, Severity.Defect);
    private static final Comparator<Severity> SEVERITY_COMPARATOR = Comparator.comparingInt(SEVERITIES::indexOf);
    private static final Comparator<TypedDetektFinding> FINDING_COMPARATOR = Comparator.comparing(f -> f.severity, SEVERITY_COMPARATOR).thenComparing(f -> f.type).thenComparing(f -> f.name);
    private final AnalyzerConfig config;
    private final DetektCollector collector;
    private final Config detektConfig;
    private final List<RuleSetProvider> ruleSetProviders;

    public DetektAnalyzer(AnalyzerConfig config, DetektCollector collector) {
        this(config, collector, null, Collections.emptyList());
    }

    private DetektAnalyzer(AnalyzerConfig config, DetektCollector collector, Config detektConfig, List<RuleSetProvider> ruleSetProviders) {
        this.config = config;
        this.collector = collector;
        this.detektConfig = detektConfig;
        this.ruleSetProviders = ruleSetProviders;
    }

    public DetektAnalyzer withConfig(Config detektConfig) {
        return new DetektAnalyzer(this.config, this.collector, detektConfig, this.ruleSetProviders);
    }

    public DetektAnalyzer withRuleSets(RuleSetProvider ... providers) {
        return new DetektAnalyzer(this.config, this.collector, this.detektConfig, Arrays.asList(providers));
    }

    public DetektResult analyze() {
        File baseDir = new File(AnalyzerConfig.Path.commonBase(this.config.getSourcePaths(Language.KOTLIN)).getPath());
        try {
            ProcessingSettings settings = new ProcessingSettings(baseDir.toPath(), this.calcDetektConfig(), Collections.emptyList(), false, false, Collections.emptyList(), Executors.newSingleThreadExecutor(), new PrintStream((OutputStream)new LoggingOutputStream(), true, "utf-8"));
            DetektFacade df = DetektFacade.Companion.create(settings, this.ruleSetProviders(settings), Collections.emptyList());
            return this.createResult(baseDir, df.run());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    private Config calcDetektConfig() {
        return new NoFormat(this.detektConfig == null ? YamlConfig.Companion.loadResource(DetektAnalyzer.class.getResource("default-detekt-config.yml")) : this.detektConfig);
    }

    private List<RuleSetProvider> ruleSetProviders(ProcessingSettings settings) {
        List res = new RuleSetLocator(settings).load();
        res.addAll(this.ruleSetProviders);
        return res;
    }

    private DetektResult createResult(File baseDir, Detektion detektion) {
        UsageCounter counter = new UsageCounter();
        List<TypedDetektFinding> findings = detektion.getFindings().entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(finding -> new TypedDetektFinding(baseDir, (String)entry.getKey(), (Finding)finding)).filter(typed -> counter.accept(this.collector.accept((TypedDetektFinding)typed)))).sorted(FINDING_COMPARATOR).collect(Collectors.toList());
        this.collector.printUnusedWarning(counter);
        return new DetektResult(this, findings, this.collector.unusedActions(counter));
    }

    private static class LoggingOutputStream
    extends OutputStream {
        private final byte[] buf = new byte[1024];
        private int pos;

        private LoggingOutputStream() {
        }

        @Override
        public void write(int b) {
            this.buf[this.pos++] = (byte)b;
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            LOG.warn(new String(this.buf, 0, this.pos, StandardCharsets.UTF_8));
            this.pos = 0;
        }
    }

    private static class NoFormat
    implements Config {
        private final Config delegate;

        NoFormat(Config delegate) {
            this.delegate = delegate;
        }

        public Config subConfig(String s) {
            return this.delegate.subConfig(s);
        }

        public <T> T valueOrDefault(String s, T t) {
            return (T)("autoCorrect".equals(s) ? Boolean.FALSE : this.delegate.valueOrDefault(s, t));
        }

        public <T> T valueOrNull(String s) {
            return (T)("autoCorrect".equals(s) ? Boolean.FALSE : this.delegate.valueOrNull(s));
        }
    }
}

