/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.dependency;

import guru.nidi.codeassert.dependency.DependencyMap;
import guru.nidi.codeassert.model.UsingElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

class Tarjan<T extends UsingElement<T>> {
    private int index;
    private final Stack<T> stack = new Stack();
    private final Map<String, Node> nodes = new HashMap<String, Node>();
    private final Set<DependencyMap> result = new HashSet<DependencyMap>();

    Tarjan() {
    }

    public Set<DependencyMap> analyzeCycles(Iterable<T> elems, boolean allowIntraPackageCycles) {
        this.index = 0;
        HashMap<String, UsingElement> map = new HashMap<String, UsingElement>();
        for (UsingElement elem : elems) {
            map.put(elem.getName(), elem);
            if (this.node(elem).index >= 0) continue;
            this.strongConnect(elem);
        }
        return this.removeInnerCycles(map, true, allowIntraPackageCycles);
    }

    private Set<DependencyMap> removeInnerCycles(Map<String, T> elems, boolean innerClasses, boolean intraPackages) {
        HashSet<DependencyMap> res = new HashSet<DependencyMap>();
        for (DependencyMap map : this.result) {
            DependencyMap filtered = new DependencyMap();
            for (String from : map.getElements()) {
                for (Map.Entry<String, DependencyMap.Info> entry : map.getDependencies(from).entrySet()) {
                    boolean intraPackageOk;
                    String to = entry.getKey();
                    boolean innerClassOk = innerClasses && this.areInnerClasses(from, to);
                    boolean bl = intraPackageOk = intraPackages && this.areSamePackage(elems, from, to);
                    if (innerClassOk || intraPackageOk) continue;
                    filtered.with(entry.getValue().getSpecificity(), from, entry.getValue().getVias(), to);
                }
            }
            if (filtered.isEmpty()) continue;
            res.add(filtered);
        }
        return res;
    }

    private boolean areSamePackage(Map<String, T> elems, String c1, String c2) {
        return ((UsingElement)elems.get(c1)).getPackageName().equals(((UsingElement)elems.get(c2)).getPackageName());
    }

    private boolean areInnerClasses(String c1, String c2) {
        return c1.startsWith(c2 + "$") || c2.startsWith(c1 + "$");
    }

    private Node node(T elem) {
        Node node = this.nodes.get(((UsingElement)elem).getName());
        if (node == null) {
            node = new Node();
            this.nodes.put(((UsingElement)elem).getName(), node);
        }
        return node;
    }

    private void strongConnect(T elem) {
        Set<T> group;
        Node v = this.init(elem);
        this.processUses(elem, v);
        if (v.lowlink == v.index && (group = this.createGroup(elem)).size() > 1) {
            this.addCycle(group);
        }
    }

    private Node init(T elem) {
        Node v = this.node(elem);
        v.index = this.index;
        v.lowlink = this.index++;
        this.stack.push(elem);
        v.onStack = true;
        return v;
    }

    private void processUses(T elem, Node v) {
        for (UsingElement dep : ((UsingElement)elem).uses()) {
            Node w = this.node(dep);
            if (w.index < 0) {
                this.strongConnect(dep);
                v.lowlink = Math.min(v.lowlink, w.lowlink);
                continue;
            }
            if (!w.onStack) continue;
            v.lowlink = Math.min(v.lowlink, w.index);
        }
    }

    private Set<T> createGroup(T elem) {
        UsingElement w;
        HashSet<UsingElement> group = new HashSet<UsingElement>();
        do {
            w = (UsingElement)this.stack.pop();
            this.node(w).onStack = false;
            group.add(w);
        } while (!elem.equals(w));
        return group;
    }

    private void addCycle(Set<T> group) {
        DependencyMap g = new DependencyMap();
        for (UsingElement elem : group) {
            for (UsingElement dep : elem.uses()) {
                if (!group.contains(dep)) continue;
                g.with(0, elem, dep);
            }
        }
        this.result.add(g);
    }

    private static class Node {
        int index = -1;
        int lowlink;
        boolean onStack;

        private Node() {
        }
    }
}

