/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.dependency;

import guru.nidi.codeassert.Analyzer;
import guru.nidi.codeassert.config.AnalyzerConfig;
import guru.nidi.codeassert.config.Language;
import guru.nidi.codeassert.config.LocationMatcher;
import guru.nidi.codeassert.config.UsageCounter;
import guru.nidi.codeassert.dependency.Dependencies;
import guru.nidi.codeassert.dependency.DependencyCollector;
import guru.nidi.codeassert.dependency.DependencyEntry;
import guru.nidi.codeassert.dependency.DependencyMap;
import guru.nidi.codeassert.dependency.DependencyResult;
import guru.nidi.codeassert.dependency.DependencyRules;
import guru.nidi.codeassert.model.Model;
import guru.nidi.codeassert.model.Scope;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DependencyAnalyzer
implements Analyzer<Dependencies> {
    private static final String DUMMY_CLASS = ".DummyClass";
    private final Model model;
    private final DependencyRules rules;
    private final Scope scope;
    private final DependencyCollector collector;

    public DependencyAnalyzer(AnalyzerConfig config) {
        this(Model.from(config.getClasses(new Language[0])), DependencyRules.denyAll(), Scope.PACKAGES, new DependencyCollector());
    }

    public DependencyAnalyzer(Model model) {
        this(model, DependencyRules.denyAll(), Scope.PACKAGES, new DependencyCollector());
    }

    private DependencyAnalyzer(Model model, DependencyRules rules, Scope scope, DependencyCollector collect) {
        this.model = model;
        this.rules = rules;
        this.scope = scope;
        this.collector = collect;
    }

    public DependencyAnalyzer rules(DependencyRules rules) {
        return new DependencyAnalyzer(this.model, rules, this.scope, this.collector);
    }

    public DependencyAnalyzer scope(Scope scope) {
        return new DependencyAnalyzer(this.model, this.rules, scope, this.collector);
    }

    public DependencyAnalyzer collector(DependencyCollector collector) {
        return new DependencyAnalyzer(this.model, this.rules, this.scope, collector);
    }

    public DependencyResult analyze() {
        Dependencies dependencies = this.rules.analyzeRules(this.scope.in(this.model));
        UsageCounter counter = new UsageCounter();
        Dependencies filtered = new Dependencies(new DependencyMap(), new DependencyMap(), new DependencyMap(), this.handleNotExisting(dependencies, counter), this.handleUndefined(dependencies, counter), this.handleCycles(dependencies, counter));
        this.handleMissing(dependencies, counter, filtered);
        this.handleDenied(dependencies, counter, filtered);
        this.collector.printUnusedWarning(counter);
        return new DependencyResult(this, filtered, this.collector.unusedActions(counter));
    }

    private void handleMissing(Dependencies dependencies, UsageCounter counter, Dependencies filtered) {
        for (String name : dependencies.missing.getElements()) {
            if (!counter.accept(this.collector.accept(new DependencyEntry("MISSING", this.className(name))))) continue;
            filtered.missing.with(name, dependencies.missing);
        }
    }

    private void handleDenied(Dependencies dependencies, UsageCounter counter, Dependencies filtered) {
        for (String name : dependencies.denied.getElements()) {
            if (!counter.accept(this.collector.accept(new DependencyEntry("DENIED", this.className(name))))) continue;
            filtered.denied.with(name, dependencies.denied);
        }
    }

    private Set<DependencyMap> handleCycles(Dependencies dependencies, UsageCounter counter) {
        HashSet<DependencyMap> res = new HashSet<DependencyMap>();
        for (DependencyMap cycle : dependencies.cycles) {
            DependencyMap map = new DependencyMap();
            for (String from : cycle.getElements()) {
                if (!counter.accept(this.collector.accept(new DependencyEntry("CYCLE", this.className(from))))) continue;
                for (Map.Entry<String, DependencyMap.Info> to : cycle.getDependencies(from).entrySet()) {
                    if (!counter.accept(this.collector.accept(new DependencyEntry("CYCLE", this.className(to.getKey()))))) continue;
                    map.with(to.getValue().getSpecificity(), from, to.getValue().getVias(), to.getKey());
                }
            }
            if (map.isEmpty()) continue;
            res.add(map);
        }
        return res;
    }

    private Set<String> handleUndefined(Dependencies dependencies, UsageCounter counter) {
        HashSet<String> res = new HashSet<String>();
        for (String name : dependencies.undefined) {
            if (!counter.accept(this.collector.accept(new DependencyEntry("UNDEFINED", this.className(name))))) continue;
            res.add(name);
        }
        return res;
    }

    private Set<LocationMatcher> handleNotExisting(Dependencies dependencies, UsageCounter counter) {
        HashSet<LocationMatcher> res = new HashSet<LocationMatcher>();
        for (LocationMatcher name : dependencies.notExisting) {
            if (!counter.accept(this.collector.accept(new DependencyEntry("NOT_EXISTING", this.className(name))))) continue;
            res.add(name);
        }
        return res;
    }

    private String className(Object name) {
        return this.scope instanceof Scope.Packages ? name + DUMMY_CLASS : name.toString();
    }
}

