/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="assert", defaultPhase=LifecyclePhase.TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class AssertMojo
extends AbstractMojo {
    static final String JACOCO_VERSION = "0.7.9";
    @Parameter(property="testClass", defaultValue="CodeCoverage")
    private String testClass;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.report();
        if (this.canRunTest()) {
            this.runTest();
        }
    }

    private void report() throws MojoExecutionException {
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.jacoco"), (String)MojoExecutor.artifactId((String)"jacoco-maven-plugin"), (String)MojoExecutor.version((String)JACOCO_VERSION)), (String)MojoExecutor.goal((String)"report"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[0]), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
    }

    private void runTest() throws MojoExecutionException {
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-surefire-plugin"), (String)MojoExecutor.version((String)"2.19.1")), (String)MojoExecutor.goal((String)"test"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"test", (String)this.testClass), MojoExecutor.element((String)"failIfNoTests", (String)"false")}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
    }

    private boolean canRunTest() throws MojoExecutionException {
        try {
            return this.existsCoverageTest() && this.existsCoverageData();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error searching test class", (Exception)e);
        }
    }

    private boolean existsCoverageData() {
        String coverageData = this.mavenProject.getBuild().getDirectory() + "/site/jacoco/jacoco.csv";
        if (!new File(coverageData).exists()) {
            this.getLog().warn((CharSequence)("No coverage data found at '" + coverageData + "'. Are there no tests?"));
            return false;
        }
        return true;
    }

    private boolean existsCoverageTest() throws IOException {
        File testDir = new File(this.mavenProject.getBuild().getTestOutputDirectory());
        List testFiles = FileUtils.getFiles((File)testDir, (String)("**/" + this.testClass + ".class"), (String)"");
        if (testFiles.isEmpty()) {
            this.getLog().warn((CharSequence)("Code coverage test not found: '" + this.testClass + ".java'."));
            return false;
        }
        return true;
    }
}

