/*
 * StructFinder.java
 *
 * Created on March 22nd, 2012
 */

package findstruct;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;

import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;

/**
 *
 * @author Andreea Bodnari
 */
public class StructFinder {

    private StructModel template = null;
    
    /** Creates a new instance of StructFinder */
    public StructFinder(String templateFile) {
	    SAXBuilder parser = new SAXBuilder();
    	try {
    	    FileInputStream templateContent = new FileInputStream(templateFile);
    	    template = new StructModel(parser.build(templateContent));
    	} catch (JDOMException e) {
    	    System.err.println("Error parsing template file "
    		    + templateFile + ": " + e);
    	} catch (FileNotFoundException e){
            System.err.println("Could not find file: " + templateFile);
            e.printStackTrace();
        } catch (IOException e){
            System.err.println("IOException from the parser reading the template file: " + templateFile);
            e.printStackTrace();
        }
    }   

    /**
     * Main method that takes in the content of a file to process
     * and the input stream of a template of section names 
     * and returns the section names found in the given file
     * @param wholeFile
     * @param templateContent
     * 
     * @return a list with the found sections
     */
    public ArrayList<Section> execute(String wholeFile) {
	ArrayList<Section> foundSections = new ArrayList<Section>();

	if (template!=null) {
	    if (wholeFile!=null) { 
		Element e = template.process(wholeFile);

		for(Object el : e.getContent()) {
		    // find the type of the element
		    if (el.getClass().equals(Text.class)) {
			Section sct = new Section("root", ((Text)el).getText());
			foundSections.add(sct);
		    }
		    else if (el.getClass().equals(Element.class)) {
			Element foundElement = ((Element)el);
			Section sct = new Section(foundElement.getName(), 
				foundElement.getText());
			foundSections.add(sct);
		    }
		}
	    }
	}

	return foundSections;
    }
}
