/*
 * Copyright 2002-2005 Uwyn bvba/sprl <info[remove] at uwyn dot com>
 * Distributed under the terms of the GNU Lesser General Public
 * License, v2.1 or later
 *
 * $Id: InvalidSearchSyntaxException.java 1178 2005-01-05 20:38:38Z gbevin $
 */
package com.uwyn.drone.modules.logmanagement.exceptions;

import com.uwyn.drone.core.Bot;
import com.uwyn.drone.core.Channel;
import com.uwyn.drone.modules.exceptions.LogManagerException;
import com.uwyn.rife.database.exceptions.DatabaseException;

public class InvalidSearchSyntaxException extends LogManagerException
{
	private	Bot		mBot = null;
	private Channel	mChannel = null;
	private String	mSearch = null;
	
	public InvalidSearchSyntaxException(Bot bot, Channel channel, String searchKey)
	{
		this(bot, channel, searchKey, null);
	}

	public InvalidSearchSyntaxException(Bot bot, Channel channel, String search, DatabaseException cause)
	{
		super("Invalid syntax while searching a log message with '"+search+"' for bot '"+bot.getName()+"' and channel '"+channel.getName()+"'.", cause);
		
		mBot = bot;
		mChannel= channel;
		mSearch = search;
	}
	
	public Bot getBot()
	{
		return mBot;
	}
	
	public Channel getChannel()
	{
		return mChannel;
	}
	
	public String getSearch()
	{
		return mSearch;
	}
}

