/*
 * Copyright 2002-2005 Uwyn bvba/sprl <info[remove] at uwyn dot com>
 * Distributed under the terms of the GNU Lesser General Public
 * License, v2.1 or later
 *
 * $Id: org_postgresql_Driver.java 1178 2005-01-05 20:38:38Z gbevin $
 */
package com.uwyn.drone.modules.logmanagement.databasedrivers;

import com.uwyn.drone.core.Bot;
import com.uwyn.drone.core.Channel;
import com.uwyn.drone.modules.exceptions.LogManagerException;
import com.uwyn.drone.modules.logmanagement.DatabaseLogs;
import com.uwyn.drone.modules.logmanagement.LogResultProcessor;
import com.uwyn.drone.protocol.ServerMessage;
import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.queries.CreateTable;
import com.uwyn.rife.database.queries.DropTable;
import com.uwyn.rife.database.queries.Insert;
import com.uwyn.rife.database.queries.Select;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public class generic extends DatabaseLogs
{
	protected CreateTable	mCreateTableLog = null;
	protected String		mCreateGetLogMessagesIndex = null;
	protected Insert		mAddLog = null;
	protected Select		mSearchLog = null;
	protected Select		mGetLogMessages = null;
	protected DropTable		mDropTableLog = null;
	protected String		mDropGetLogMessagesIndex = null;

	public generic(Datasource datasource)
	{
		super(datasource);

		mCreateTableLog = new CreateTable(getDatasource())
			.table("log")
			.column("moment", Timestamp.class, CreateTable.NOTNULL)
			.column("botname", String.class, 30, CreateTable.NOTNULL)
			.column("channel", String.class, 30, CreateTable.NOTNULL)
			.column("servername", String.class, 60, CreateTable.NOTNULL)
			.column("nickname", String.class, 30, CreateTable.NOTNULL)
			.column("username", String.class, 30, CreateTable.NOTNULL)
			.column("hostname", String.class, 255, CreateTable.NOTNULL)
			.column("message", String.class, CreateTable.NOTNULL)
			.column("raw", String.class, CreateTable.NOTNULL);

		mCreateGetLogMessagesIndex = "CREATE INDEX log_getlog_idx ON "+mCreateTableLog.getTable()+" (botname, channel, servername, moment)";

		mAddLog = new Insert(getDatasource())
			.into(mCreateTableLog.getTable())
			.fieldCustom("moment", "CURRENT_TIMESTAMP")
			.fieldParameter("botname")
			.fieldParameter("channel")
			.fieldParameter("servername")
			.fieldParameter("nickname")
			.fieldParameter("username")
			.fieldParameter("hostname")
			.fieldParameter("message")
			.fieldParameter("raw");

		mSearchLog = (Select)new Select(getDatasource())
			.from(mCreateTableLog.getTable())
			.field("moment")
			.field("raw")
			.orderBy("moment", Select.DESC)
			.whereParameter("botname", "=")
			.whereParameterAnd("channel", "=")
			.whereParameterAnd("servername", "=");

		mGetLogMessages = (Select)new Select(getDatasource())
			.from(mCreateTableLog.getTable())
			.field("moment")
			.field("raw")
			.orderBy("moment", Select.ASC)
			.whereParameter("botname", "=")
			.whereParameterAnd("channel", "=")
			.whereParameterAnd("servername", "=")
			.whereParameterAnd("moment", "begin", ">=")
			.whereParameterAnd("moment", "end", "<");

		mDropTableLog = new DropTable(getDatasource())
			.table(mCreateTableLog.getTable());

		mDropGetLogMessagesIndex = "DROP INDEX log_getlog_idx";
	}

	public boolean install()
	throws LogManagerException
	{
		return _install(mCreateTableLog, mCreateGetLogMessagesIndex);
	}

	public void addLog(Date moment, Bot bot, Channel channel, ServerMessage serverMessage)
	throws LogManagerException
	{
		_addLog(mAddLog, bot, channel, serverMessage);
	}

	public boolean searchLog(LogResultProcessor processor, Bot bot, Channel channel, String search)
	throws LogManagerException
	{
		return _searchLog(mSearchLog, processor, bot, channel, search);
	}

	public boolean getLogMessages(LogResultProcessor processor, Bot bot, Channel channel, Calendar day)
	throws LogManagerException
	{
		return _getLogMessages(mGetLogMessages, processor, bot, channel, day);
	}

	public boolean remove()
	throws LogManagerException
	{
		return _remove(mDropTableLog, mDropGetLogMessagesIndex);
	}
}
