/*
 * Copyright 2002-2005 Uwyn bvba/sprl <info[remove] at uwyn dot com>
 * Distributed under the terms of the GNU Lesser General Public
 * License, v2.1 or later
 *
 * $Id: UnknownServerHostnameException.java 1178 2005-01-05 20:38:38Z gbevin $
 */
package com.uwyn.drone.core.exceptions;

public class UnknownServerHostnameException extends CoreException
{
	private String	mHostname = null;
	
	public UnknownServerHostnameException(String hostname, Throwable cause)
	{
		super("The server hostname '"+hostname+"' couldn't be found.", cause);
		
		mHostname = hostname;
	}
	
	public String getHostname()
	{
		return mHostname;
	}
}

