/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.search.tools;

import com.uwyn.rife.config.Config;
import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.search.dam.indexqueuequerymanagers.IndexQueue;
import com.uwyn.rife.search.dam.indexqueuequerymanagers.IndexQueueFactory;
import com.uwyn.rife.tools.ExceptionUtils;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.nl.DutchAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;

public class SearchTool {
    public static final int LUCENE_MERGE_FACTOR = 10;
    public static final int LUCENE_MIN_MERGE_DOCS = 100;
    protected IndexQueue mIndexQueueManager = null;

    public SearchTool(Datasource datasource) {
        this.mIndexQueueManager = IndexQueueFactory.getInstance(datasource);
    }

    public IndexWriter getIndexWriter(String name, boolean truncate) {
        String lucene_dir = null;
        try {
            lucene_dir = this.ensureLuceneDir();
        }
        catch (IOException e) {
            Logger.getLogger("com.uwyn.rife.search.tools").severe(ExceptionUtils.getExceptionStackTrace((Throwable)e));
            return null;
        }
        StringBuffer location = new StringBuffer();
        location.append(lucene_dir).append(File.separator).append(name);
        IndexWriter index_writer = null;
        try {
            index_writer = new IndexWriter(location.toString(), this.getAnalyzer(), truncate);
            index_writer.mergeFactor = 10;
            index_writer.minMergeDocs = 100;
        }
        catch (IOException e) {
            Logger.getLogger("com.uwyn.rife.search.tools").warning("Creation of the writer failed. Attempting to " + "create the directory first...");
            File file = new File(location.toString());
            if (file.exists()) {
                File segments = new File(location.toString() + File.separator + "segments");
                if (segments.exists()) {
                    Logger.getLogger("com.uwyn.rife.search.tools").severe("Correct directory and segments exists, " + "but cannot create the writer. Most " + "likely caused by a stale lockfile.");
                    Logger.getLogger("com.uwyn.rife.search.tools").severe(ExceptionUtils.getExceptionStackTrace((Throwable)e));
                    return null;
                }
                truncate = true;
            } else {
                file.mkdir();
                truncate = true;
            }
            try {
                index_writer = new IndexWriter(location.toString(), this.getAnalyzer(), truncate);
                index_writer.mergeFactor = 10;
                index_writer.minMergeDocs = 100;
            }
            catch (IOException e1) {
                Logger.getLogger("com.uwyn.rife.search.tools").warning("Creation of the writer failed again. Giving up...");
                Logger.getLogger("com.uwyn.rife.search.tools").warning(ExceptionUtils.getExceptionStackTrace((Throwable)e1));
                return null;
            }
        }
        return index_writer;
    }

    public IndexReader getIndexReader(String name) {
        String lucene_dir = null;
        try {
            lucene_dir = this.ensureLuceneDir();
        }
        catch (IOException e) {
            Logger.getLogger("com.uwyn.rife.search.tools").severe(ExceptionUtils.getExceptionStackTrace((Throwable)e));
            return null;
        }
        StringBuffer location = new StringBuffer();
        location.append(lucene_dir).append(File.separator).append(name);
        IndexReader reader = null;
        try {
            reader = IndexReader.open((String)location.toString());
        }
        catch (IOException e) {
            Logger.getLogger("com.uwyn.rife.search.tools").warning("Creation of the reader failed '" + name + "'.");
        }
        return reader;
    }

    protected String ensureLuceneDir() throws IOException {
        String dir = Config.getRepInstance().getString("LUCENE_DIR");
        if (dir != null) {
            File file = new File(dir);
            if (!file.exists()) {
                file.mkdir();
                Logger.getLogger("com.uwyn.rife.search.tools").warning("Created search index directory: " + dir);
            }
            if (!file.canRead() || !file.canWrite()) {
                throw new IOException("Permissions problems on search index directory (" + dir + "). Must be read/write.");
            }
        } else {
            throw new IOException("Config parameter LUCENE_DIR not defined. No search will be available.");
        }
        return dir;
    }

    protected Analyzer getAnalyzer() {
        String language = Config.getRepInstance().getString("L10N_DEFAULT_LANGUAGE");
        if (language == null) {
            return new StandardAnalyzer();
        }
        if (language.equals("fr")) {
            return new FrenchAnalyzer();
        }
        if (language.equals("nl")) {
            return new DutchAnalyzer();
        }
        return new StandardAnalyzer();
    }

    public void cleanupIndexWriter(IndexWriter indexWriter, Throwable e) {
        if (e != null) {
            Logger.getLogger("com.uwyn.rife.search.tools").severe(ExceptionUtils.getExceptionStackTrace((Throwable)e));
        }
        if (indexWriter == null) {
            return;
        }
        try {
            try {
                indexWriter.optimize();
            }
            catch (IOException e2) {
                Logger.getLogger("com.uwyn.rife.search.tools").severe(ExceptionUtils.getExceptionStackTrace((Throwable)e2));
                try {
                    indexWriter.close();
                }
                catch (IOException e1) {
                    Logger.getLogger("com.uwyn.rife.search.tools").severe(ExceptionUtils.getExceptionStackTrace((Throwable)e1));
                }
                return;
            }
        }
        finally {
            try {
                indexWriter.close();
            }
            catch (IOException e1) {
                Logger.getLogger("com.uwyn.rife.search.tools").severe(ExceptionUtils.getExceptionStackTrace((Throwable)e1));
            }
        }
        Object var1_1 = null;
    }

    public boolean deleteDocument(String indexName, Term unique_term) {
        try {
            this.ensureLuceneDir();
        }
        catch (IOException e) {
            Logger.getLogger("com.uwyn.rife.search.tools").severe(ExceptionUtils.getExceptionStackTrace((Throwable)e));
            return false;
        }
        IndexReader reader = this.getIndexReader(indexName);
        if (reader == null) {
            return false;
        }
        try {
            try {
                reader.delete(unique_term);
                boolean bl = true;
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        Logger.getLogger("com.uwyn.rife.search.tools").severe(ExceptionUtils.getExceptionStackTrace((Throwable)e));
                    }
                }
                return bl;
            }
            catch (IOException e) {
                Logger.getLogger("com.uwyn.rife.search.tools").severe(ExceptionUtils.getExceptionStackTrace((Throwable)e));
                boolean bl = false;
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e2) {
                        Logger.getLogger("com.uwyn.rife.search.tools").severe(ExceptionUtils.getExceptionStackTrace((Throwable)e2));
                    }
                }
                return bl;
            }
        }
        catch (Throwable throwable) {
            block16: {
                if (reader == null) break block16;
                try {
                    reader.close();
                }
                catch (IOException e) {
                    Logger.getLogger("com.uwyn.rife.search.tools").severe(ExceptionUtils.getExceptionStackTrace((Throwable)e));
                }
            }
            throw throwable;
        }
    }

    public boolean addDocumentToQueue(String indexName, Document doc) {
        return this.mIndexQueueManager.saveDocument(indexName, doc);
    }

    public boolean indexDocument(String indexName, Document doc) {
        IndexWriter writer = this.getIndexWriter(indexName, false);
        try {
            try {
                writer.addDocument(doc);
            }
            catch (IOException e) {
                Logger.getLogger("com.uwyn.rife.search.tools").severe(ExceptionUtils.getExceptionStackTrace((Throwable)e));
                boolean bl = false;
                if (writer != null) {
                    this.cleanupIndexWriter(writer, null);
                }
                return bl;
            }
        }
        finally {
            if (writer != null) {
                this.cleanupIndexWriter(writer, null);
            }
        }
        return true;
    }
}

