/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.search.executors;

import com.uwyn.rife.config.Config;
import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.Datasources;
import com.uwyn.rife.database.DbQueryManager;
import com.uwyn.rife.database.queries.Delete;
import com.uwyn.rife.database.queries.Query;
import com.uwyn.rife.database.queries.Update;
import com.uwyn.rife.database.querymanagers.generic.GenericQueryManager;
import com.uwyn.rife.database.querymanagers.generic.GenericQueryManagerFactory;
import com.uwyn.rife.database.querymanagers.generic.RestoreQuery;
import com.uwyn.rife.scheduler.Executor;
import com.uwyn.rife.scheduler.Task;
import com.uwyn.rife.scheduler.exceptions.SchedulerException;
import com.uwyn.rife.search.dao.IndexDocument;
import com.uwyn.rife.search.dao.IndexField;
import com.uwyn.rife.search.executors.IndexQueueAction;
import com.uwyn.rife.search.tools.SearchTool;
import com.uwyn.rife.tools.ExceptionUtils;
import com.uwyn.rife.tools.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexQueueExecutor
extends Executor {
    private static Object sRunningMonitor = new Object();
    private static boolean sRunning = false;
    private Datasource mDatasource = null;
    private GenericQueryManager<IndexDocument> mIndexDocumentManager = null;
    private GenericQueryManager<IndexField> mIndexFieldManager = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean executeTask(Task task) {
        Class<?> clazz;
        Class<?> clazz2;
        String datasource_name = null;
        try {
            datasource_name = task.getTaskoptionValue("datasource_name");
        }
        catch (SchedulerException e) {
            Logger.getLogger("com.uwyn.rife.search.executors").severe(ExceptionUtils.getExceptionStackTrace((Throwable)e));
            datasource_name = null;
        }
        if (datasource_name == null) {
            datasource_name = Config.getRepInstance().getString("DATASOURCE");
        }
        this.mDatasource = Datasources.getRepInstance().getDatasource(datasource_name);
        try {
            clazz2 = Class.forName("com.uwyn.rife.search.dao.IndexDocument");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.mIndexDocumentManager = GenericQueryManagerFactory.getInstance((Datasource)this.mDatasource, clazz2);
        try {
            clazz = Class.forName("com.uwyn.rife.search.dao.IndexField");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.mIndexFieldManager = GenericQueryManagerFactory.getInstance((Datasource)this.mDatasource, clazz);
        Logger.getLogger("com.uwyn.rife.search.executors").info("Trying to start indexing queue run...");
        Object object = sRunningMonitor;
        synchronized (object) {
            block24: {
                Logger.getLogger("com.uwyn.rife.search.executors").info("got lock...");
                if (!sRunning) {
                    Logger.getLogger("com.uwyn.rife.search.executors").info("no one running...");
                    sRunning = true;
                    try {
                        List<Delete> deleteFlaggedFieldsList;
                        Delete delete_flagged;
                        SearchTool searchTool = new SearchTool(this.mDatasource);
                        Update flag_messages = new Update(this.mDatasource);
                        flag_messages.table(this.mIndexDocumentManager.getTable()).field("queueFlag", true);
                        new DbQueryManager(this.mDatasource).executeUpdate((Query)flag_messages);
                        RestoreQuery query = this.mIndexDocumentManager.getRestoreQuery();
                        query.where("queueFlag", "=", true);
                        List indexDocumentList = this.mIndexDocumentManager.restore(query);
                        ArrayList<Integer> indexDocumentIds = new ArrayList<Integer>(indexDocumentList.size());
                        HashMap<String, IndexWriter> indexWriterCache = new HashMap<String, IndexWriter>();
                        Iterator iterator = ((Collection)indexDocumentList).iterator();
                        while (true) {
                            if (!iterator.hasNext()) break;
                            IndexDocument indexDocument = (IndexDocument)((Object)iterator.next());
                            Document doc = new Document();
                            RestoreQuery indexFieldsQuery = this.mIndexFieldManager.getRestoreQuery();
                            indexFieldsQuery.where("indexDocumentId", "=", indexDocument.getId());
                            List indexFieldList = this.mIndexFieldManager.restore(indexFieldsQuery);
                            Iterator iterator2 = ((Collection)indexFieldList).iterator();
                            while (true) {
                                if (!iterator2.hasNext()) {
                                    IndexWriter writer = (IndexWriter)indexWriterCache.get(indexDocument.getIndexName());
                                    if (writer == null) {
                                        writer = searchTool.getIndexWriter(indexDocument.getIndexName(), false);
                                        indexWriterCache.put(indexDocument.getIndexName(), writer);
                                    }
                                    try {
                                        writer.addDocument(doc);
                                    }
                                    catch (IOException e) {
                                        Logger.getLogger("com.uwyn.rife.search.executors").severe(ExceptionUtils.getExceptionStackTrace((Throwable)e));
                                    }
                                    break;
                                }
                                IndexField indexField = (IndexField)((Object)iterator2.next());
                                String name = indexField.getName();
                                String value = indexField.getValue();
                                boolean stored = indexField.getIsStore();
                                boolean indexed = indexField.getIsIndex();
                                boolean tokenized = indexField.getIsToken();
                                doc.add(new Field(name, value, stored, indexed, tokenized));
                            }
                            indexDocumentIds.add(new Integer(indexDocument.getId()));
                        }
                        Iterator iterator3 = ((Collection)indexWriterCache.entrySet()).iterator();
                        while (true) {
                            if (!iterator3.hasNext()) {
                                delete_flagged = new Delete(this.mDatasource);
                                delete_flagged.from(this.mIndexDocumentManager.getTable()).where("queueFlag", "=", true);
                                deleteFlaggedFieldsList = this.getDeleteFlaggedFieldsList(indexDocumentIds);
                                if (indexDocumentIds.size() > 0) {
                                    break;
                                }
                                break block24;
                            }
                            Map.Entry entry = (Map.Entry)iterator3.next();
                            searchTool.cleanupIndexWriter((IndexWriter)entry.getValue(), null);
                        }
                        DbQueryManager dbQueryManager = new DbQueryManager(this.mDatasource);
                        Iterator iterator4 = ((Collection)deleteFlaggedFieldsList).iterator();
                        while (true) {
                            if (!iterator4.hasNext()) {
                                dbQueryManager.executeUpdate((Query)delete_flagged);
                                break block24;
                            }
                            Delete delete_flagged_fields = (Delete)iterator4.next();
                            dbQueryManager.executeUpdate((Query)delete_flagged_fields);
                        }
                    }
                    finally {
                        sRunning = false;
                    }
                }
                Logger.getLogger("com.uwyn.rife.search.executors").info("someone running...");
            }
            Logger.getLogger("com.uwyn.rife.search.executors").info("done");
            return true;
        }
    }

    private List<Delete> getDeleteFlaggedFieldsList(List<Integer> indexDocumentIds) {
        ArrayList<Integer> documentIds = new ArrayList<Integer>();
        List<Integer> growList = null;
        ArrayList<Delete> deleteFlaggedFieldsList = new ArrayList<Delete>();
        growList = Collections.nCopies(indexDocumentIds.size(), new Integer(-1));
        documentIds.addAll(growList);
        Collections.copy(documentIds, indexDocumentIds);
        while (documentIds.size() != 0) {
            ArrayList<Integer> ids = new ArrayList<Integer>();
            while (documentIds.size() != 0 && ids.size() < 100) {
                ids.add((Integer)documentIds.remove(0));
            }
            Delete delete_flagged_fields = new Delete(this.mDatasource);
            delete_flagged_fields.from(this.mIndexFieldManager.getTable()).where(new StringBuffer().append(new StringBuffer().append("indexDocumentId IN (").append(StringUtils.join(ids, (String)",")).toString()).append(")").toString());
            deleteFlaggedFieldsList.add(delete_flagged_fields);
        }
        return deleteFlaggedFieldsList;
    }

    public void customQueueAction(IndexQueueAction action) {
        boolean hasRun = false;
        while (!hasRun) {
            Object object = sRunningMonitor;
            synchronized (object) {
                if (!sRunning) {
                    sRunning = true;
                    try {
                        action.performAction();
                    }
                    finally {
                        sRunning = false;
                        hasRun = true;
                    }
                }
            }
        }
    }

    public String getHandledTasktype() {
        return "IndexQueue";
    }
}

